/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v419;

import io.netty.buffer.ByteBuf;
import java.util.List;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.EntityDataTypeMap;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v407.BedrockCodecHelper_v407;
import oxy.toviabedrock.shaded.protocol.bedrock.data.ExperimentData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ContainerSlotType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.skin.AnimatedTextureType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.skin.AnimationData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.skin.AnimationExpressionType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.skin.ImageData;
import oxy.toviabedrock.shaded.protocol.common.util.TypeMap;

public class BedrockCodecHelper_v419
extends BedrockCodecHelper_v407 {
    protected static final AnimationExpressionType[] EXPRESSION_TYPES = AnimationExpressionType.values();

    public BedrockCodecHelper_v419(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes, TypeMap<ItemStackRequestActionType> stackRequestActionTypes, TypeMap<ContainerSlotType> containerSlotTypes) {
        super(entityData, gameRulesTypes, stackRequestActionTypes, containerSlotTypes);
    }

    @Override
    public void readExperiments(ByteBuf buffer, List<ExperimentData> experiments) {
        int count = buffer.readIntLE();
        for (int i = 0; i < count; ++i) {
            experiments.add(new ExperimentData(this.readString(buffer), buffer.readBoolean()));
        }
    }

    @Override
    public void writeExperiments(ByteBuf buffer, List<ExperimentData> experiments) {
        buffer.writeIntLE(experiments.size());
        for (ExperimentData experiment : experiments) {
            this.writeString(buffer, experiment.getName());
            buffer.writeBoolean(experiment.isEnabled());
        }
    }

    @Override
    public AnimationData readAnimationData(ByteBuf buffer) {
        ImageData image = this.readImage(buffer, 0x100000);
        AnimatedTextureType textureType = TEXTURE_TYPES[buffer.readIntLE()];
        float frames = buffer.readFloatLE();
        AnimationExpressionType expressionType = EXPRESSION_TYPES[buffer.readIntLE()];
        return new AnimationData(image, textureType, frames, expressionType);
    }

    @Override
    public void writeAnimationData(ByteBuf buffer, AnimationData animation) {
        super.writeAnimationData(buffer, animation);
        buffer.writeIntLE(animation.getExpressionType().ordinal());
    }
}

