/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v575.serializer;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockPacketSerializer;
import oxy.toviabedrock.shaded.protocol.bedrock.data.camera.CameraEase;
import oxy.toviabedrock.shaded.protocol.bedrock.data.camera.CameraFadeInstruction;
import oxy.toviabedrock.shaded.protocol.bedrock.data.camera.CameraSetInstruction;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.CameraInstructionPacket;
import oxy.toviabedrock.shaded.protocol.common.NamedDefinition;
import oxy.toviabedrock.shaded.protocol.common.util.DefinitionUtils;
import oxy.toviabedrock.shaded.protocol.common.util.OptionalBoolean;
import oxy.toviabedrock.shaded.protocol.common.util.Preconditions;

public class CameraInstructionSerializer_v575
implements BedrockPacketSerializer<CameraInstructionPacket> {
    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, CameraInstructionPacket packet) {
        NbtMapBuilder builder;
        NbtMapBuilder tag = NbtMap.builder();
        if (packet.getSetInstruction() != null) {
            CameraSetInstruction set = packet.getSetInstruction();
            DefinitionUtils.checkDefinition(helper.getCameraPresetDefinitions(), set.getPreset());
            builder = NbtMap.builder().putInt("preset", set.getPreset().getRuntimeId());
            if (set.getEase() != null) {
                builder.putCompound("ease", NbtMap.builder().putString("type", set.getEase().getEaseType().getSerializeName()).putFloat("time", set.getEase().getTime()).build());
            }
            if (set.getPos() != null) {
                builder.putCompound("pos", NbtMap.builder().putList("pos", NbtType.FLOAT, (Object[])new Float[]{Float.valueOf(set.getPos().getX()), Float.valueOf(set.getPos().getY()), Float.valueOf(set.getPos().getZ())}).build());
            }
            if (set.getRot() != null) {
                builder.putCompound("rot", NbtMap.builder().putFloat("x", set.getRot().getX()).putFloat("y", set.getRot().getY()).build());
            }
            if (set.getDefaultPreset().isPresent()) {
                builder.putBoolean("default", set.getDefaultPreset().getAsBoolean());
            }
            tag.put("set", (Object)builder.build());
        }
        if (packet.getClear().isPresent()) {
            tag.putBoolean("clear", packet.getClear().getAsBoolean());
        }
        if (packet.getFadeInstruction() != null) {
            CameraFadeInstruction fade = packet.getFadeInstruction();
            builder = NbtMap.builder();
            if (fade.getTimeData() != null) {
                builder.putCompound("time", NbtMap.builder().putFloat("fadeIn", fade.getTimeData().getFadeInTime()).putFloat("hold", fade.getTimeData().getWaitTime()).putFloat("fadeOut", fade.getTimeData().getFadeOutTime()).build());
            }
            if (fade.getColor() != null) {
                builder.putCompound("color", NbtMap.builder().putFloat("r", (float)fade.getColor().getRed() / 255.0f).putFloat("g", (float)fade.getColor().getBlue() / 255.0f).putFloat("b", (float)fade.getColor().getGreen() / 255.0f).build());
            }
            tag.put("fade", (Object)builder.build());
        }
        helper.writeTag(buffer, tag.build());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, CameraInstructionPacket packet) {
        NbtMap tag = helper.readTag(buffer, NbtMap.class);
        if (tag.containsKey("set", NbtType.COMPOUND)) {
            CameraSetInstruction set = new CameraSetInstruction();
            NbtMap setTag = tag.getCompound("set");
            int runtimeId = setTag.getInt("preset");
            NamedDefinition definition = helper.getCameraPresetDefinitions().getDefinition(runtimeId);
            Preconditions.checkNotNull(definition, "Unknown camera preset " + runtimeId);
            set.setPreset(definition);
            if (setTag.containsKey("ease", NbtType.COMPOUND)) {
                NbtMap easeTag = setTag.getCompound("ease");
                CameraEase type = CameraEase.fromName(easeTag.getString("type"));
                float time = easeTag.getFloat("time");
                set.setEase(new CameraSetInstruction.EaseData(type, time));
            }
            if (setTag.containsKey("pos", NbtType.COMPOUND)) {
                List floats = setTag.getCompound("pos").getList("pos", NbtType.FLOAT);
                float x = floats.size() > 0 ? ((Float)floats.get(0)).floatValue() : 0.0f;
                float y = floats.size() > 1 ? ((Float)floats.get(1)).floatValue() : 0.0f;
                float z = floats.size() > 2 ? ((Float)floats.get(2)).floatValue() : 0.0f;
                set.setPos(Vector3f.from((float)x, (float)y, (float)z));
            }
            if (setTag.containsKey("rot", NbtType.COMPOUND)) {
                NbtMap rot = setTag.getCompound("rot");
                float pitch = rot.containsKey("x", NbtType.FLOAT) ? rot.getFloat("x") : 0.0f;
                float yaw = rot.containsKey("y", NbtType.FLOAT) ? rot.getFloat("y") : 0.0f;
                set.setRot(Vector2f.from((float)pitch, (float)yaw));
            }
            if (setTag.containsKey("default", NbtType.BYTE)) {
                set.setDefaultPreset(OptionalBoolean.of(setTag.getBoolean("default")));
            }
            packet.setSetInstruction(set);
        }
        if (tag.containsKey("clear", NbtType.BYTE)) {
            packet.setClear(OptionalBoolean.of(tag.getBoolean("clear")));
        }
        if (tag.containsKey("fade", NbtType.COMPOUND)) {
            CameraFadeInstruction fade = new CameraFadeInstruction();
            NbtMap fadeTag = tag.getCompound("fade");
            if (fadeTag.containsKey("time", NbtType.COMPOUND)) {
                NbtMap timeTag = fadeTag.getCompound("time");
                float fadeIn = timeTag.getFloat("fadeIn");
                float wait = timeTag.getFloat("hold");
                float fadeout = timeTag.getFloat("fadeOut");
                fade.setTimeData(new CameraFadeInstruction.TimeData(fadeIn, wait, fadeout));
            }
            if (fadeTag.containsKey("color", NbtType.COMPOUND)) {
                NbtMap colorTag = tag.getCompound("color");
                fade.setColor(new Color((int)(colorTag.getFloat("r") * 255.0f), (int)(colorTag.getFloat("b") * 255.0f), (int)(colorTag.getFloat("g") * 255.0f)));
            }
            packet.setFadeInstruction(fade);
        }
    }
}

