/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v582.serializer;

import io.netty.buffer.ByteBuf;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v567.serializer.CraftingDataSerializer_v567;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.CraftingDataType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.FurnaceRecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.MultiRecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.RecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.ShapelessRecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.SmithingTransformRecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.SmithingTrimRecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class CraftingDataSerializer_v582
extends CraftingDataSerializer_v567 {
    @Override
    protected RecipeData readEntry(ByteBuf buffer, BedrockCodecHelper helper) {
        int typeInt = VarInts.readInt(buffer);
        CraftingDataType type = CraftingDataType.byId(typeInt);
        switch (type) {
            case SHAPELESS: 
            case SHAPELESS_CHEMISTRY: 
            case SHULKER_BOX: {
                return this.readShapelessRecipe(buffer, helper, type);
            }
            case SHAPED: 
            case SHAPED_CHEMISTRY: {
                return this.readShapedRecipe(buffer, helper, type);
            }
            case FURNACE: {
                return this.readFurnaceRecipe(buffer, helper, type);
            }
            case FURNACE_DATA: {
                return this.readFurnaceDataRecipe(buffer, helper, type);
            }
            case MULTI: {
                return this.readMultiRecipe(buffer, helper, type);
            }
            case SMITHING_TRANSFORM: {
                return this.readSmithingTransformRecipe(buffer, helper, type);
            }
            case SMITHING_TRIM: {
                return this.readSmithingTrimRecipe(buffer, helper, type);
            }
        }
        throw new IllegalArgumentException("Unhandled crafting data type: " + (Object)((Object)type));
    }

    @Override
    protected void writeEntry(ByteBuf buffer, BedrockCodecHelper helper, RecipeData craftingData) {
        VarInts.writeInt(buffer, craftingData.getType().ordinal());
        switch (craftingData.getType()) {
            case SHAPELESS: 
            case SHAPELESS_CHEMISTRY: 
            case SHULKER_BOX: {
                this.writeShapelessRecipe(buffer, helper, (ShapelessRecipeData)craftingData);
                break;
            }
            case SHAPED: 
            case SHAPED_CHEMISTRY: {
                this.writeShapedRecipe(buffer, helper, (ShapedRecipeData)craftingData);
                break;
            }
            case FURNACE: {
                this.writeFurnaceRecipe(buffer, helper, (FurnaceRecipeData)craftingData);
                break;
            }
            case FURNACE_DATA: {
                this.writeFurnaceDataRecipe(buffer, helper, (FurnaceRecipeData)craftingData);
                break;
            }
            case MULTI: {
                this.writeMultiRecipe(buffer, helper, (MultiRecipeData)craftingData);
                break;
            }
            case SMITHING_TRANSFORM: {
                this.writeSmithingTransformRecipe(buffer, helper, (SmithingTransformRecipeData)craftingData);
                break;
            }
            case SMITHING_TRIM: {
                this.writeSmithingTrimRecipe(buffer, helper, (SmithingTrimRecipeData)craftingData);
            }
        }
    }

    protected SmithingTrimRecipeData readSmithingTrimRecipe(ByteBuf buffer, BedrockCodecHelper helper, CraftingDataType type) {
        String id = helper.readString(buffer);
        ItemDescriptorWithCount template = helper.readIngredient(buffer);
        ItemDescriptorWithCount base = helper.readIngredient(buffer);
        ItemDescriptorWithCount addition = helper.readIngredient(buffer);
        return SmithingTrimRecipeData.of(id, base, addition, template, helper.readString(buffer), VarInts.readUnsignedInt(buffer));
    }

    protected void writeSmithingTrimRecipe(ByteBuf buffer, BedrockCodecHelper helper, SmithingTrimRecipeData data) {
        helper.writeString(buffer, data.getId());
        helper.writeIngredient(buffer, data.getTemplate());
        helper.writeIngredient(buffer, data.getBase());
        helper.writeIngredient(buffer, data.getAddition());
        helper.writeString(buffer, data.getTag());
        VarInts.writeUnsignedInt(buffer, data.getNetId());
    }

    @Override
    protected SmithingTransformRecipeData readSmithingTransformRecipe(ByteBuf buffer, BedrockCodecHelper helper, CraftingDataType type) {
        return SmithingTransformRecipeData.of(helper.readString(buffer), helper.readIngredient(buffer), helper.readIngredient(buffer), helper.readIngredient(buffer), helper.readItemInstance(buffer), helper.readString(buffer), VarInts.readUnsignedInt(buffer));
    }

    @Override
    protected void writeSmithingTransformRecipe(ByteBuf buffer, BedrockCodecHelper helper, SmithingTransformRecipeData data) {
        helper.writeString(buffer, data.getId());
        helper.writeIngredient(buffer, data.getTemplate());
        helper.writeIngredient(buffer, data.getBase());
        helper.writeIngredient(buffer, data.getAddition());
        helper.writeItemInstance(buffer, data.getResult());
        helper.writeString(buffer, data.getTag());
        VarInts.writeUnsignedInt(buffer, data.getNetId());
    }
}

