/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v729.serializer;

import io.netty.buffer.ByteBuf;
import oxy.toviabedrock.shaded.fastutil.objects.ObjectArrayList;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v544.serializer.UpdateAttributesSerializer_v544;
import oxy.toviabedrock.shaded.protocol.bedrock.data.AttributeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.attribute.AttributeModifierData;
import oxy.toviabedrock.shaded.protocol.common.util.Preconditions;

public class UpdateAttributesSerializer_v729
extends UpdateAttributesSerializer_v544 {
    public static final UpdateAttributesSerializer_v729 INSTANCE = new UpdateAttributesSerializer_v729();

    @Override
    public void writeAttribute(ByteBuf buffer, BedrockCodecHelper helper, AttributeData attribute) {
        Preconditions.checkNotNull(attribute, "attribute");
        buffer.writeFloatLE(attribute.getMinimum());
        buffer.writeFloatLE(attribute.getMaximum());
        buffer.writeFloatLE(attribute.getValue());
        buffer.writeFloatLE(attribute.getDefaultMinimum());
        buffer.writeFloatLE(attribute.getDefaultMaximum());
        buffer.writeFloatLE(attribute.getDefaultValue());
        helper.writeString(buffer, attribute.getName());
        helper.writeArray(buffer, attribute.getModifiers(), this::writeModifier);
    }

    @Override
    public AttributeData readAttribute(ByteBuf buffer, BedrockCodecHelper helper) {
        float min = buffer.readFloatLE();
        float max = buffer.readFloatLE();
        float val2 = buffer.readFloatLE();
        float defMin = buffer.readFloatLE();
        float defMax = buffer.readFloatLE();
        float def = buffer.readFloatLE();
        String name = helper.readString(buffer);
        ObjectArrayList<AttributeModifierData> modifiers = new ObjectArrayList<AttributeModifierData>();
        helper.readArray(buffer, modifiers, this::readModifier);
        return new AttributeData(name, min, max, val2, defMin, defMax, def, modifiers);
    }

    protected UpdateAttributesSerializer_v729() {
    }
}

