/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v776.serializer;

import io.netty.buffer.ByteBuf;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v486.serializer.BossEventSerializer_v486;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BossEventPacket;
import oxy.toviabedrock.shaded.protocol.common.util.TextConverter;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class BossEventSerializer_v776
extends BossEventSerializer_v486 {
    public static final BossEventSerializer_v776 INSTANCE = new BossEventSerializer_v776();

    @Override
    protected void serializeAction(ByteBuf buffer, BedrockCodecHelper helper, BossEventPacket packet) {
        TextConverter converter = helper.getTextConverter();
        if (packet.getAction() == BossEventPacket.Action.CREATE) {
            helper.writeString(buffer, converter.serialize(packet.getTitle(CharSequence.class)));
            helper.writeString(buffer, converter.serialize(packet.getFilteredTitle(CharSequence.class)));
            buffer.writeFloatLE(packet.getHealthPercentage());
            buffer.writeShortLE(packet.getDarkenSky());
            VarInts.writeUnsignedInt(buffer, packet.getColor());
            VarInts.writeUnsignedInt(buffer, packet.getOverlay());
        } else if (packet.getAction() == BossEventPacket.Action.UPDATE_NAME) {
            helper.writeString(buffer, converter.serialize(packet.getTitle(CharSequence.class)));
            helper.writeString(buffer, converter.serialize(packet.getFilteredTitle(CharSequence.class)));
        } else {
            super.serializeAction(buffer, helper, packet);
        }
    }

    @Override
    protected void deserializeAction(ByteBuf buffer, BedrockCodecHelper helper, BossEventPacket packet) {
        TextConverter converter = helper.getTextConverter();
        if (packet.getAction() == BossEventPacket.Action.CREATE) {
            packet.setTitle(converter.deserialize(helper.readString(buffer)));
            packet.setFilteredTitle(converter.deserialize(helper.readString(buffer)));
            packet.setHealthPercentage(buffer.readFloatLE());
            packet.setDarkenSky(buffer.readUnsignedShortLE());
            packet.setColor(VarInts.readUnsignedInt(buffer));
            packet.setOverlay(VarInts.readUnsignedInt(buffer));
        } else if (packet.getAction() == BossEventPacket.Action.UPDATE_NAME) {
            packet.setTitle(converter.deserialize(helper.readString(buffer)));
            packet.setFilteredTitle(converter.deserialize(helper.readString(buffer)));
        } else {
            super.deserializeAction(buffer, helper, packet);
        }
    }

    protected BossEventSerializer_v776() {
    }
}

