/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v844;

import io.netty.buffer.ByteBuf;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.EntityDataTypeMap;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v776.BedrockCodecHelper_v776;
import oxy.toviabedrock.shaded.protocol.bedrock.data.Ability;
import oxy.toviabedrock.shaded.protocol.bedrock.data.GameRuleData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ContainerSlotType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.TextProcessingEventOrigin;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import oxy.toviabedrock.shaded.protocol.common.util.Preconditions;
import oxy.toviabedrock.shaded.protocol.common.util.TypeMap;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class BedrockCodecHelper_v844
extends BedrockCodecHelper_v776 {
    public BedrockCodecHelper_v844(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes, TypeMap<ItemStackRequestActionType> stackRequestActionTypes, TypeMap<ContainerSlotType> containerSlotTypes, TypeMap<Ability> abilities, TypeMap<TextProcessingEventOrigin> textProcessingEventOrigins) {
        super(entityData, gameRulesTypes, stackRequestActionTypes, containerSlotTypes, abilities, textProcessingEventOrigins);
    }

    @Override
    public void writeGameRule(ByteBuf buffer, GameRuleData<?> gameRule) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(gameRule, "gameRule");
        Object value = gameRule.getValue();
        int id = this.gameRuleType.getId(value.getClass());
        this.writeString(buffer, gameRule.getName());
        buffer.writeBoolean(gameRule.isEditable());
        VarInts.writeUnsignedInt(buffer, id);
        switch (id) {
            case 1: {
                buffer.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                buffer.writeIntLE(((Integer)value).intValue());
                break;
            }
            case 3: {
                buffer.writeFloatLE(((Float)value).floatValue());
            }
        }
    }

    @Override
    public GameRuleData<?> readGameRule(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        String name = this.readString(buffer);
        boolean editable = buffer.readBoolean();
        int type = VarInts.readUnsignedInt(buffer);
        switch (type) {
            case 1: {
                return new GameRuleData<Boolean>(name, editable, buffer.readBoolean());
            }
            case 2: {
                return new GameRuleData<Integer>(name, editable, buffer.readIntLE());
            }
            case 3: {
                return new GameRuleData<Float>(name, editable, Float.valueOf(buffer.readFloatLE()));
            }
        }
        throw new IllegalStateException("Invalid gamerule type received");
    }

    @Override
    public void writeGameRuleInStartGame(ByteBuf buffer, GameRuleData<?> gameRule) {
        Preconditions.checkNotNull(buffer, "buffer");
        Preconditions.checkNotNull(gameRule, "gameRule");
        Object value = gameRule.getValue();
        int id = this.gameRuleType.getId(value.getClass());
        this.writeString(buffer, gameRule.getName());
        buffer.writeBoolean(gameRule.isEditable());
        VarInts.writeUnsignedInt(buffer, id);
        switch (id) {
            case 1: {
                buffer.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                VarInts.writeInt(buffer, (Integer)value);
                break;
            }
            case 3: {
                buffer.writeFloatLE(((Float)value).floatValue());
            }
        }
    }

    @Override
    public GameRuleData<?> readGameRuleInStartGame(ByteBuf buffer) {
        Preconditions.checkNotNull(buffer, "buffer");
        String name = this.readString(buffer);
        boolean editable = buffer.readBoolean();
        int type = VarInts.readUnsignedInt(buffer);
        switch (type) {
            case 1: {
                return new GameRuleData<Boolean>(name, editable, buffer.readBoolean());
            }
            case 2: {
                return new GameRuleData<Integer>(name, editable, VarInts.readInt(buffer));
            }
            case 3: {
                return new GameRuleData<Float>(name, editable, Float.valueOf(buffer.readFloatLE()));
            }
        }
        throw new IllegalStateException("Invalid gamerule type received");
    }
}

