/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v844.serializer;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.List;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.v827.serializer.BiomeDefinitionListSerializer_v827;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeCappedSurfaceData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeClimateData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeConsolidatedFeatureData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeDefinitionChunkGenData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeDefinitionData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeLegacyWorldGenRulesData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeMesaSurfaceData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeMountainParamsData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeMultinoiseGenRulesData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeOverworldGenRulesData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeSurfaceMaterialAdjustmentData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.biome.BiomeSurfaceMaterialData;
import oxy.toviabedrock.shaded.protocol.common.util.Preconditions;
import oxy.toviabedrock.shaded.protocol.common.util.SequencedHashSet;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;
import oxy.toviabedrock.shaded.protocol.common.util.index.Indexed;
import oxy.toviabedrock.shaded.protocol.common.util.index.IndexedList;

public class BiomeDefinitionListSerializer_v844
extends BiomeDefinitionListSerializer_v827 {
    public static final BiomeDefinitionListSerializer_v844 INSTANCE = new BiomeDefinitionListSerializer_v844();

    @Override
    protected void writeDefinition(ByteBuf buffer, BedrockCodecHelper helper, BiomeDefinitionData definition, SequencedHashSet<String> strings) {
        this.writeDefinitionId(buffer, helper, definition, strings);
        buffer.writeFloatLE(definition.getTemperature());
        buffer.writeFloatLE(definition.getDownfall());
        buffer.writeFloatLE(definition.getFoliageSnow());
        buffer.writeFloatLE(definition.getDepth());
        buffer.writeFloatLE(definition.getScale());
        buffer.writeIntLE(definition.getMapWaterColor().getRGB());
        buffer.writeBoolean(definition.isRain());
        helper.writeOptionalNull(buffer, definition.getTags(), (byteBuf, aHelper, tags) -> {
            VarInts.writeUnsignedInt(byteBuf, tags.size());
            for (String tag : tags) {
                byteBuf.writeShortLE(strings.addAndGetIndex(tag));
            }
        });
        helper.writeOptionalNull(buffer, definition.getChunkGenData(), (buf, aHelper, data) -> this.writeDefinitionChunkGen((ByteBuf)buf, (BedrockCodecHelper)aHelper, (BiomeDefinitionChunkGenData)data, strings));
    }

    @Override
    protected BiomeDefinitionData readDefinition(ByteBuf buffer, BedrockCodecHelper helper, List<String> strings) {
        Indexed<String> id = this.readDefinitionId(buffer, helper, strings);
        float temperature = buffer.readFloatLE();
        float downfall = buffer.readFloatLE();
        float foliageSnow = buffer.readFloatLE();
        float depth = buffer.readFloatLE();
        float scale = buffer.readFloatLE();
        Color mapWaterColor = new Color(buffer.readIntLE(), true);
        boolean rain = buffer.readBoolean();
        IndexedList tags = helper.readOptional(buffer, null, byteBuf -> {
            int length = VarInts.readUnsignedInt(byteBuf);
            Preconditions.checkArgument(byteBuf.isReadable(length * 2), "Not enough readable bytes for tags");
            int[] array = new int[length];
            for (int i = 0; i < length; ++i) {
                array[i] = byteBuf.readUnsignedShortLE();
            }
            return new IndexedList(strings, array);
        });
        BiomeDefinitionChunkGenData chunkGenData = helper.readOptional(buffer, null, (buf, aHelper) -> this.readDefinitionChunkGen((ByteBuf)buf, (BedrockCodecHelper)aHelper, strings));
        return new BiomeDefinitionData(id, temperature, downfall, foliageSnow, depth, scale, mapWaterColor, rain, tags, chunkGenData);
    }

    @Override
    protected void writeDefinitionChunkGen(ByteBuf buffer, BedrockCodecHelper helper, BiomeDefinitionChunkGenData definitionChunkGen, SequencedHashSet<String> strings) {
        helper.writeOptionalNull(buffer, definitionChunkGen.getClimate(), this::writeClimate);
        helper.writeOptionalNull(buffer, definitionChunkGen.getConsolidatedFeatures(), (buf, aHelper, consolidatedFeatures) -> this.writeConsolidatedFeatures((ByteBuf)buf, (BedrockCodecHelper)aHelper, (List<BiomeConsolidatedFeatureData>)consolidatedFeatures, strings));
        helper.writeOptionalNull(buffer, definitionChunkGen.getMountainParams(), this::writeMountainParamsData);
        helper.writeOptionalNull(buffer, definitionChunkGen.getSurfaceMaterialAdjustment(), (buf, aHelper, surfaceMaterialAdjustment) -> this.writeSurfaceMaterialAdjustment((ByteBuf)buf, (BedrockCodecHelper)aHelper, (BiomeSurfaceMaterialAdjustmentData)surfaceMaterialAdjustment, strings));
        helper.writeOptionalNull(buffer, definitionChunkGen.getSurfaceMaterial(), this::writeSurfaceMaterial);
        buffer.writeBoolean(definitionChunkGen.isHasDefaultOverworldSurface());
        buffer.writeBoolean(definitionChunkGen.isHasSwampSurface());
        buffer.writeBoolean(definitionChunkGen.isHasFrozenOceanSurface());
        buffer.writeBoolean(definitionChunkGen.isHasTheEndSurface());
        helper.writeOptionalNull(buffer, definitionChunkGen.getMesaSurface(), this::writeMesaSurface);
        helper.writeOptionalNull(buffer, definitionChunkGen.getCappedSurface(), this::writeCappedSurface);
        helper.writeOptionalNull(buffer, definitionChunkGen.getOverworldGenRules(), (buf, aHelper, overworldGenRules) -> this.writeOverworldGenRules((ByteBuf)buf, (BedrockCodecHelper)aHelper, (BiomeOverworldGenRulesData)overworldGenRules, strings));
        helper.writeOptionalNull(buffer, definitionChunkGen.getMultinoiseGenRules(), this::writeMultinoiseGenRules);
        helper.writeOptionalNull(buffer, definitionChunkGen.getLegacyWorldGenRules(), (buf, aHelper, legacyWorldGenRules) -> this.writeLegacyWorldGenRules((ByteBuf)buf, (BedrockCodecHelper)aHelper, (BiomeLegacyWorldGenRulesData)legacyWorldGenRules, strings));
    }

    @Override
    protected BiomeDefinitionChunkGenData readDefinitionChunkGen(ByteBuf buffer, BedrockCodecHelper helper, List<String> strings) {
        BiomeClimateData climate = helper.readOptional(buffer, null, this::readClimate);
        List consolidatedFeatures = helper.readOptional(buffer, null, (buf, aHelper) -> this.readConsolidatedFeatures((ByteBuf)buf, (BedrockCodecHelper)aHelper, strings));
        BiomeMountainParamsData mountainParams = helper.readOptional(buffer, null, this::readMountainParamsData);
        BiomeSurfaceMaterialAdjustmentData surfaceMaterialAdjustment = helper.readOptional(buffer, null, (buf, aHelper) -> this.readSurfaceMaterialAdjustment((ByteBuf)buf, (BedrockCodecHelper)aHelper, strings));
        BiomeSurfaceMaterialData surfaceMaterial = helper.readOptional(buffer, null, this::readSurfaceMaterial);
        boolean hasDefaultOverworldSurface = buffer.readBoolean();
        boolean hasSwampSurface = buffer.readBoolean();
        boolean hasFrozenOceanSurface = buffer.readBoolean();
        boolean hasTheEndSurface = buffer.readBoolean();
        BiomeMesaSurfaceData mesaSurface = helper.readOptional(buffer, null, this::readMesaSurface);
        BiomeCappedSurfaceData cappedSurface = helper.readOptional(buffer, null, this::readCappedSurface);
        BiomeOverworldGenRulesData overworldGenRules = helper.readOptional(buffer, null, (buf, aHelper) -> this.readOverworldGenRules((ByteBuf)buf, (BedrockCodecHelper)aHelper, strings));
        BiomeMultinoiseGenRulesData multinoiseGenRules = helper.readOptional(buffer, null, this::readMultinoiseGenRules);
        BiomeLegacyWorldGenRulesData legacyWorldGenRules = helper.readOptional(buffer, null, (buf, aHelper) -> this.readLegacyWorldGenRules((ByteBuf)buf, (BedrockCodecHelper)aHelper, strings));
        return new BiomeDefinitionChunkGenData(climate, consolidatedFeatures, mountainParams, surfaceMaterialAdjustment, surfaceMaterial, hasDefaultOverworldSurface, hasSwampSurface, hasFrozenOceanSurface, hasTheEndSurface, mesaSurface, cappedSurface, overworldGenRules, multinoiseGenRules, legacyWorldGenRules);
    }

    @Override
    protected void writeClimate(ByteBuf buffer, BedrockCodecHelper helper, BiomeClimateData climate) {
        buffer.writeFloatLE(climate.getTemperature());
        buffer.writeFloatLE(climate.getDownfall());
        buffer.writeFloatLE(climate.getSnowAccumulationMin());
        buffer.writeFloatLE(climate.getSnowAccumulationMax());
    }

    @Override
    protected BiomeClimateData readClimate(ByteBuf buffer, BedrockCodecHelper helper) {
        float temperature = buffer.readFloatLE();
        float downfall = buffer.readFloatLE();
        float snowAccumulationMin = buffer.readFloatLE();
        float snowAccumulationMax = buffer.readFloatLE();
        return new BiomeClimateData(temperature, downfall, 0.0f, 0.0f, 0.0f, 0.0f, snowAccumulationMin, snowAccumulationMax);
    }
}

