/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.codec.v844.serializer;

import io.netty.buffer.ByteBuf;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import oxy.toviabedrock.shaded.protocol.bedrock.codec.BedrockPacketSerializer;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.ServerboundPackSettingChangePacket;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class ServerboundPackSettingChangeSerializer_v844
implements BedrockPacketSerializer<ServerboundPackSettingChangePacket> {
    public static final ServerboundPackSettingChangeSerializer_v844 INSTANCE = new ServerboundPackSettingChangeSerializer_v844();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ServerboundPackSettingChangePacket packet) {
        helper.writeUuid(buffer, packet.getPackId());
        helper.writeString(buffer, packet.getPackSettingName());
        Object value = packet.getPackSettingValue();
        int type = value instanceof Float ? 0 : (value instanceof Boolean ? 1 : (value instanceof String ? 2 : -1));
        VarInts.writeUnsignedInt(buffer, type);
        switch (type) {
            case 0: {
                buffer.writeFloatLE(((Float)value).floatValue());
                break;
            }
            case 1: {
                buffer.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                helper.writeString(buffer, (String)value);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid pack setting type");
            }
        }
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ServerboundPackSettingChangePacket packet) {
        packet.setPackId(helper.readUuid(buffer));
        packet.setPackSettingName(helper.readString(buffer));
        int type = VarInts.readUnsignedInt(buffer);
        switch (type) {
            case 0: {
                packet.setPackSettingValue(Float.valueOf(buffer.readFloatLE()));
                break;
            }
            case 1: {
                packet.setPackSettingValue(buffer.readBoolean());
                break;
            }
            case 2: {
                packet.setPackSettingValue(helper.readString(buffer));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid pack setting type");
            }
        }
    }

    protected ServerboundPackSettingChangeSerializer_v844() {
    }
}

