/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.data;

public class EncodingSettings {
    public static final EncodingSettings DEFAULT = EncodingSettings.builder().maxListSize(1536).maxByteArraySize(0x100000).maxNetworkNBTSize(0x20000000).maxItemNBTSize(102400).maxStringLength(32768).maxGeometryDataSize(524288).maxItemStackTagLength(64).maxInventoryActionsOrRequests(64).build();
    public static final EncodingSettings CLIENT = EncodingSettings.builder().maxListSize(10240).maxByteArraySize(0x1400000).maxNetworkNBTSize(0xA00000).maxItemNBTSize(0x500000).maxStringLength(0x200000).maxGeometryDataSize(524288).maxItemStackTagLength(64).maxInventoryActionsOrRequests(64).build();
    public static final EncodingSettings SERVER = EncodingSettings.builder().maxListSize(1024).maxByteArraySize(524288).maxNetworkNBTSize(524288).maxItemNBTSize(102400).maxStringLength(32768).maxGeometryDataSize(262144).maxItemStackTagLength(64).maxInventoryActionsOrRequests(64).build();
    public static final EncodingSettings UNLIMITED = EncodingSettings.builder().maxListSize(-1).maxByteArraySize(-1).maxNetworkNBTSize(-1).maxItemNBTSize(-1).maxStringLength(-1).maxItemStackTagLength(-1).maxGeometryDataSize(-1).maxInventoryActionsOrRequests(-1).build();
    private final int maxListSize;
    private final int maxByteArraySize;
    private final int maxNetworkNBTSize;
    private final int maxItemNBTSize;
    private final int maxStringLength;
    private final int maxItemStackTagLength;
    private final int maxGeometryDataSize;
    private final int maxInventoryActionsOrRequests;

    EncodingSettings(int maxListSize, int maxByteArraySize, int maxNetworkNBTSize, int maxItemNBTSize, int maxStringLength, int maxItemStackTagLength, int maxGeometryDataSize, int maxInventoryActionsOrRequests) {
        this.maxListSize = maxListSize;
        this.maxByteArraySize = maxByteArraySize;
        this.maxNetworkNBTSize = maxNetworkNBTSize;
        this.maxItemNBTSize = maxItemNBTSize;
        this.maxStringLength = maxStringLength;
        this.maxItemStackTagLength = maxItemStackTagLength;
        this.maxGeometryDataSize = maxGeometryDataSize;
        this.maxInventoryActionsOrRequests = maxInventoryActionsOrRequests;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().maxListSize(this.maxListSize).maxByteArraySize(this.maxByteArraySize).maxNetworkNBTSize(this.maxNetworkNBTSize).maxItemNBTSize(this.maxItemNBTSize).maxStringLength(this.maxStringLength).maxItemStackTagLength(this.maxItemStackTagLength).maxGeometryDataSize(this.maxGeometryDataSize).maxInventoryActionsOrRequests(this.maxInventoryActionsOrRequests);
    }

    public int maxListSize() {
        return this.maxListSize;
    }

    public int maxByteArraySize() {
        return this.maxByteArraySize;
    }

    public int maxNetworkNBTSize() {
        return this.maxNetworkNBTSize;
    }

    public int maxItemNBTSize() {
        return this.maxItemNBTSize;
    }

    public int maxStringLength() {
        return this.maxStringLength;
    }

    public int maxItemStackTagLength() {
        return this.maxItemStackTagLength;
    }

    public int maxGeometryDataSize() {
        return this.maxGeometryDataSize;
    }

    public int maxInventoryActionsOrRequests() {
        return this.maxInventoryActionsOrRequests;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncodingSettings)) {
            return false;
        }
        EncodingSettings other = (EncodingSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxListSize() != other.maxListSize()) {
            return false;
        }
        if (this.maxByteArraySize() != other.maxByteArraySize()) {
            return false;
        }
        if (this.maxNetworkNBTSize() != other.maxNetworkNBTSize()) {
            return false;
        }
        if (this.maxItemNBTSize() != other.maxItemNBTSize()) {
            return false;
        }
        if (this.maxStringLength() != other.maxStringLength()) {
            return false;
        }
        if (this.maxItemStackTagLength() != other.maxItemStackTagLength()) {
            return false;
        }
        if (this.maxGeometryDataSize() != other.maxGeometryDataSize()) {
            return false;
        }
        return this.maxInventoryActionsOrRequests() == other.maxInventoryActionsOrRequests();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncodingSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxListSize();
        result = result * 59 + this.maxByteArraySize();
        result = result * 59 + this.maxNetworkNBTSize();
        result = result * 59 + this.maxItemNBTSize();
        result = result * 59 + this.maxStringLength();
        result = result * 59 + this.maxItemStackTagLength();
        result = result * 59 + this.maxGeometryDataSize();
        result = result * 59 + this.maxInventoryActionsOrRequests();
        return result;
    }

    public String toString() {
        return "EncodingSettings(maxListSize=" + this.maxListSize() + ", maxByteArraySize=" + this.maxByteArraySize() + ", maxNetworkNBTSize=" + this.maxNetworkNBTSize() + ", maxItemNBTSize=" + this.maxItemNBTSize() + ", maxStringLength=" + this.maxStringLength() + ", maxItemStackTagLength=" + this.maxItemStackTagLength() + ", maxGeometryDataSize=" + this.maxGeometryDataSize() + ", maxInventoryActionsOrRequests=" + this.maxInventoryActionsOrRequests() + ")";
    }

    public static class Builder {
        private int maxListSize;
        private int maxByteArraySize;
        private int maxNetworkNBTSize;
        private int maxItemNBTSize;
        private int maxStringLength;
        private int maxItemStackTagLength;
        private int maxGeometryDataSize;
        private int maxInventoryActionsOrRequests;

        Builder() {
        }

        public Builder maxListSize(int maxListSize) {
            this.maxListSize = maxListSize;
            return this;
        }

        public Builder maxByteArraySize(int maxByteArraySize) {
            this.maxByteArraySize = maxByteArraySize;
            return this;
        }

        public Builder maxNetworkNBTSize(int maxNetworkNBTSize) {
            this.maxNetworkNBTSize = maxNetworkNBTSize;
            return this;
        }

        public Builder maxItemNBTSize(int maxItemNBTSize) {
            this.maxItemNBTSize = maxItemNBTSize;
            return this;
        }

        public Builder maxStringLength(int maxStringLength) {
            this.maxStringLength = maxStringLength;
            return this;
        }

        public Builder maxItemStackTagLength(int maxItemStackTagLength) {
            this.maxItemStackTagLength = maxItemStackTagLength;
            return this;
        }

        public Builder maxGeometryDataSize(int maxGeometryDataSize) {
            this.maxGeometryDataSize = maxGeometryDataSize;
            return this;
        }

        public Builder maxInventoryActionsOrRequests(int maxInventoryActionsOrRequests) {
            this.maxInventoryActionsOrRequests = maxInventoryActionsOrRequests;
            return this;
        }

        public EncodingSettings build() {
            return new EncodingSettings(this.maxListSize, this.maxByteArraySize, this.maxNetworkNBTSize, this.maxItemNBTSize, this.maxStringLength, this.maxItemStackTagLength, this.maxGeometryDataSize, this.maxInventoryActionsOrRequests);
        }

        public String toString() {
            return "EncodingSettings.Builder(maxListSize=" + this.maxListSize + ", maxByteArraySize=" + this.maxByteArraySize + ", maxNetworkNBTSize=" + this.maxNetworkNBTSize + ", maxItemNBTSize=" + this.maxItemNBTSize + ", maxStringLength=" + this.maxStringLength + ", maxItemStackTagLength=" + this.maxItemStackTagLength + ", maxGeometryDataSize=" + this.maxGeometryDataSize + ", maxInventoryActionsOrRequests=" + this.maxInventoryActionsOrRequests + ")";
        }
    }
}

