/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.data.biome;

import com.fasterxml.jackson.annotation.JsonCreator;
import oxy.toviabedrock.shaded.protocol.common.util.index.Indexable;
import oxy.toviabedrock.shaded.protocol.common.util.index.Unindexed;

public final class BiomeWeightedData {
    private final transient Indexable<String> biome;
    private final int weight;

    @JsonCreator
    public BiomeWeightedData(String biome, int weight) {
        this.biome = new Unindexed<String>(biome);
        this.weight = weight;
    }

    public String getBiome() {
        return this.biome.get();
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiomeWeightedData)) {
            return false;
        }
        BiomeWeightedData other = (BiomeWeightedData)o;
        return this.getWeight() == other.getWeight();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWeight();
        return result;
    }

    public String toString() {
        return "BiomeWeightedData(biome=" + this.getBiome() + ", weight=" + this.getWeight() + ")";
    }

    @Deprecated
    public BiomeWeightedData(Indexable<String> biome, int weight) {
        this.biome = biome;
        this.weight = weight;
    }
}

