/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe;

import java.util.List;
import java.util.UUID;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ItemData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.CraftingDataType;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.RecipeUnlockingRequirement;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.crafting.recipe.CraftingRecipeData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import oxy.toviabedrock.shaded.protocol.common.util.Preconditions;

public class ShapelessRecipeData
implements CraftingRecipeData {
    private final CraftingDataType type;
    private final String id;
    private final List<ItemDescriptorWithCount> ingredients;
    private final List<ItemData> results;
    private final UUID uuid;
    private final String tag;
    private final int priority;
    private final int netId;
    private final RecipeUnlockingRequirement requirement;

    public static ShapelessRecipeData of(CraftingDataType type, String id, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId, RecipeUnlockingRequirement requirement) {
        Preconditions.checkArgument(type == CraftingDataType.SHAPELESS || type == CraftingDataType.SHAPELESS_CHEMISTRY || type == CraftingDataType.SHULKER_BOX, "type must be SHAPELESS, SHAPELESS_CHEMISTRY or SHULKER_BOX");
        return new ShapelessRecipeData(type, id, ingredients, results, uuid, tag, priority, netId, requirement);
    }

    public static ShapelessRecipeData of(CraftingDataType type, String id, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId) {
        return ShapelessRecipeData.of(type, id, ingredients, results, uuid, tag, priority, netId, RecipeUnlockingRequirement.INVALID);
    }

    public static ShapelessRecipeData shapeless(String id, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId, RecipeUnlockingRequirement requirement) {
        return ShapelessRecipeData.of(CraftingDataType.SHAPELESS, id, ingredients, results, uuid, tag, priority, netId, requirement);
    }

    public static ShapelessRecipeData shapelessChemistry(String id, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId) {
        return ShapelessRecipeData.of(CraftingDataType.SHAPELESS_CHEMISTRY, id, ingredients, results, uuid, tag, priority, netId);
    }

    public static ShapelessRecipeData shulkerBox(String id, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId) {
        return ShapelessRecipeData.of(CraftingDataType.SHULKER_BOX, id, ingredients, results, uuid, tag, priority, netId);
    }

    @Override
    public CraftingDataType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<ItemDescriptorWithCount> getIngredients() {
        return this.ingredients;
    }

    @Override
    public List<ItemData> getResults() {
        return this.results;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getNetId() {
        return this.netId;
    }

    @Override
    public RecipeUnlockingRequirement getRequirement() {
        return this.requirement;
    }

    public String toString() {
        return "ShapelessRecipeData(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", ingredients=" + this.getIngredients() + ", results=" + this.getResults() + ", uuid=" + this.getUuid() + ", tag=" + this.getTag() + ", priority=" + this.getPriority() + ", netId=" + this.getNetId() + ", requirement=" + this.getRequirement() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShapelessRecipeData)) {
            return false;
        }
        ShapelessRecipeData other = (ShapelessRecipeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.getNetId() != other.getNetId()) {
            return false;
        }
        CraftingDataType this$type = this.getType();
        CraftingDataType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<ItemDescriptorWithCount> this$ingredients = this.getIngredients();
        List<ItemDescriptorWithCount> other$ingredients = other.getIngredients();
        if (this$ingredients == null ? other$ingredients != null : !((Object)this$ingredients).equals(other$ingredients)) {
            return false;
        }
        List<ItemData> this$results = this.getResults();
        List<ItemData> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        RecipeUnlockingRequirement this$requirement = this.getRequirement();
        RecipeUnlockingRequirement other$requirement = other.getRequirement();
        return !(this$requirement == null ? other$requirement != null : !((Object)this$requirement).equals(other$requirement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShapelessRecipeData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        result = result * 59 + this.getNetId();
        CraftingDataType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<ItemDescriptorWithCount> $ingredients = this.getIngredients();
        result = result * 59 + ($ingredients == null ? 43 : ((Object)$ingredients).hashCode());
        List<ItemData> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        RecipeUnlockingRequirement $requirement = this.getRequirement();
        result = result * 59 + ($requirement == null ? 43 : ((Object)$requirement).hashCode());
        return result;
    }

    private ShapelessRecipeData(CraftingDataType type, String id, List<ItemDescriptorWithCount> ingredients, List<ItemData> results, UUID uuid, String tag, int priority, int netId, RecipeUnlockingRequirement requirement) {
        this.type = type;
        this.id = id;
        this.ingredients = ingredients;
        this.results = results;
        this.uuid = uuid;
        this.tag = tag;
        this.priority = priority;
        this.netId = netId;
        this.requirement = requirement;
    }
}

