/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor;

import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ItemData;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.DefaultDescriptor;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.InvalidDescriptor;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.descriptor.ItemDescriptor;

public class ItemDescriptorWithCount {
    public static final ItemDescriptorWithCount EMPTY = new ItemDescriptorWithCount(InvalidDescriptor.INSTANCE, 0);
    private final ItemDescriptor descriptor;
    private final int count;

    public ItemData toItem() {
        if (this.descriptor == InvalidDescriptor.INSTANCE) {
            return ItemData.AIR;
        }
        return this.descriptor.toItem().count(this.count).build();
    }

    public static ItemDescriptorWithCount fromItem(ItemData item) {
        if (item == ItemData.AIR) {
            return EMPTY;
        }
        return new ItemDescriptorWithCount(new DefaultDescriptor(item.getDefinition(), item.getDamage()), item.getCount());
    }

    public ItemDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        return "ItemDescriptorWithCount(descriptor=" + this.getDescriptor() + ", count=" + this.getCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemDescriptorWithCount)) {
            return false;
        }
        ItemDescriptorWithCount other = (ItemDescriptorWithCount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        ItemDescriptor this$descriptor = this.getDescriptor();
        ItemDescriptor other$descriptor = other.getDescriptor();
        return !(this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemDescriptorWithCount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        ItemDescriptor $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
        return result;
    }

    public ItemDescriptorWithCount(ItemDescriptor descriptor, int count) {
        this.descriptor = descriptor;
        this.count = count;
    }
}

