/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.netty.codec.batch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.util.ArrayDeque;
import java.util.Queue;
import oxy.toviabedrock.shaded.protocol.bedrock.netty.BedrockBatchWrapper;
import oxy.toviabedrock.shaded.protocol.bedrock.netty.BedrockPacketWrapper;
import oxy.toviabedrock.shaded.protocol.common.util.VarInts;

public class BedrockBatchEncoder
extends ChannelOutboundHandlerAdapter {
    public static final String NAME = "bedrock-batch-encoder";
    private final Queue<BedrockPacketWrapper> messages = new ArrayDeque<BedrockPacketWrapper>();

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof BedrockPacketWrapper)) {
            super.write(ctx, msg, promise);
            return;
        }
        this.messages.add((BedrockPacketWrapper)((Object)msg));
        promise.trySuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.messages.isEmpty()) {
            super.flush(ctx);
            return;
        }
        CompositeByteBuf buf = ctx.alloc().compositeDirectBuffer(this.messages.size() * 2);
        BedrockBatchWrapper batch = BedrockBatchWrapper.newInstance();
        try {
            BedrockPacketWrapper packet;
            while ((packet = this.messages.poll()) != null) {
                try {
                    ByteBuf message = packet.getPacketBuffer();
                    if (message == null) {
                        throw new IllegalArgumentException("BedrockPacket is not encoded");
                    }
                    ByteBuf header = ctx.alloc().ioBuffer(5);
                    VarInts.writeUnsignedInt(header, message.readableBytes());
                    buf.addComponent(true, header);
                    buf.addComponent(true, message.retain());
                    batch.addPacket(packet.retain());
                }
                finally {
                    packet.release();
                }
            }
            batch.setUncompressed((ByteBuf)buf.retain());
            ctx.write((Object)batch.retain());
        }
        finally {
            buf.release();
            batch.release();
        }
        super.flush(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        BedrockPacketWrapper message;
        while ((message = this.messages.poll()) != null) {
            message.release();
        }
        super.handlerRemoved(ctx);
    }
}

