/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.netty.codec.compression;

import oxy.toviabedrock.shaded.protocol.bedrock.data.CompressionAlgorithm;
import oxy.toviabedrock.shaded.protocol.bedrock.data.PacketCompressionAlgorithm;
import oxy.toviabedrock.shaded.protocol.bedrock.netty.BedrockBatchWrapper;
import oxy.toviabedrock.shaded.protocol.bedrock.netty.codec.compression.BatchCompression;
import oxy.toviabedrock.shaded.protocol.bedrock.netty.codec.compression.CompressionStrategy;
import oxy.toviabedrock.shaded.protocol.bedrock.netty.codec.compression.NoopCompression;
import oxy.toviabedrock.shaded.protocol.bedrock.netty.codec.compression.SnappyCompression;
import oxy.toviabedrock.shaded.protocol.bedrock.netty.codec.compression.ZlibCompression;
import oxy.toviabedrock.shaded.protocol.common.util.Zlib;

public class SimpleCompressionStrategy
implements CompressionStrategy {
    private final BatchCompression compression;
    private final BatchCompression none;
    private final BatchCompression zlib;
    private final BatchCompression snappy;

    public SimpleCompressionStrategy(BatchCompression compression) {
        this.compression = compression;
        this.none = new NoopCompression();
        if (compression.getAlgorithm() == PacketCompressionAlgorithm.ZLIB) {
            this.zlib = compression;
            this.snappy = new SnappyCompression();
        } else if (compression.getAlgorithm() == PacketCompressionAlgorithm.SNAPPY) {
            this.zlib = new ZlibCompression(Zlib.RAW);
            this.snappy = compression;
        } else {
            this.zlib = new ZlibCompression(Zlib.RAW);
            this.snappy = new SnappyCompression();
        }
    }

    @Override
    public BatchCompression getCompression(BedrockBatchWrapper wrapper) {
        return this.compression;
    }

    @Override
    public BatchCompression getCompression(CompressionAlgorithm algorithm) {
        if (algorithm == PacketCompressionAlgorithm.ZLIB) {
            return this.zlib;
        }
        if (algorithm == PacketCompressionAlgorithm.SNAPPY) {
            return this.snappy;
        }
        if (algorithm == PacketCompressionAlgorithm.NONE) {
            return this.none;
        }
        return this.compression;
    }

    @Override
    public BatchCompression getDefaultCompression() {
        return this.compression;
    }
}

