/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.packet;

import oxy.toviabedrock.shaded.protocol.bedrock.annotation.Incompressible;
import oxy.toviabedrock.shaded.protocol.bedrock.data.PacketCompressionAlgorithm;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketHandler;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketType;
import oxy.toviabedrock.shaded.protocol.common.PacketSignal;

@Incompressible
public class NetworkSettingsPacket
implements BedrockPacket {
    private int compressionThreshold;
    private PacketCompressionAlgorithm compressionAlgorithm;
    private boolean clientThrottleEnabled;
    private int clientThrottleThreshold;
    private float clientThrottleScalar;

    @Override
    public PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.NETWORK_SETTINGS;
    }

    @Override
    public NetworkSettingsPacket clone() {
        try {
            return (NetworkSettingsPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public PacketCompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public boolean isClientThrottleEnabled() {
        return this.clientThrottleEnabled;
    }

    public int getClientThrottleThreshold() {
        return this.clientThrottleThreshold;
    }

    public float getClientThrottleScalar() {
        return this.clientThrottleScalar;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    public void setCompressionAlgorithm(PacketCompressionAlgorithm compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public void setClientThrottleEnabled(boolean clientThrottleEnabled) {
        this.clientThrottleEnabled = clientThrottleEnabled;
    }

    public void setClientThrottleThreshold(int clientThrottleThreshold) {
        this.clientThrottleThreshold = clientThrottleThreshold;
    }

    public void setClientThrottleScalar(float clientThrottleScalar) {
        this.clientThrottleScalar = clientThrottleScalar;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkSettingsPacket)) {
            return false;
        }
        NetworkSettingsPacket other = (NetworkSettingsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.compressionThreshold != other.compressionThreshold) {
            return false;
        }
        if (this.clientThrottleEnabled != other.clientThrottleEnabled) {
            return false;
        }
        if (this.clientThrottleThreshold != other.clientThrottleThreshold) {
            return false;
        }
        if (Float.compare(this.clientThrottleScalar, other.clientThrottleScalar) != 0) {
            return false;
        }
        PacketCompressionAlgorithm this$compressionAlgorithm = this.compressionAlgorithm;
        PacketCompressionAlgorithm other$compressionAlgorithm = other.compressionAlgorithm;
        return !(this$compressionAlgorithm == null ? other$compressionAlgorithm != null : !this$compressionAlgorithm.equals(other$compressionAlgorithm));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NetworkSettingsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.compressionThreshold;
        result = result * 59 + (this.clientThrottleEnabled ? 79 : 97);
        result = result * 59 + this.clientThrottleThreshold;
        result = result * 59 + Float.floatToIntBits(this.clientThrottleScalar);
        PacketCompressionAlgorithm $compressionAlgorithm = this.compressionAlgorithm;
        result = result * 59 + ($compressionAlgorithm == null ? 43 : $compressionAlgorithm.hashCode());
        return result;
    }

    public String toString() {
        return "NetworkSettingsPacket(compressionThreshold=" + this.compressionThreshold + ", compressionAlgorithm=" + this.compressionAlgorithm + ", clientThrottleEnabled=" + this.clientThrottleEnabled + ", clientThrottleThreshold=" + this.clientThrottleThreshold + ", clientThrottleScalar=" + this.clientThrottleScalar + ")";
    }
}

