/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.bedrock.packet;

import io.netty.util.AbstractReferenceCounted;
import java.util.List;
import org.cloudburstmc.math.vector.Vector3i;
import oxy.toviabedrock.shaded.fastutil.objects.ObjectArrayList;
import oxy.toviabedrock.shaded.protocol.bedrock.data.SubChunkData;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacket;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketHandler;
import oxy.toviabedrock.shaded.protocol.bedrock.packet.BedrockPacketType;
import oxy.toviabedrock.shaded.protocol.common.PacketSignal;

public class SubChunkPacket
extends AbstractReferenceCounted
implements BedrockPacket {
    private int dimension;
    private boolean cacheEnabled;
    private Vector3i centerPosition;
    private List<SubChunkData> subChunks = new ObjectArrayList<SubChunkData>();

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.SUB_CHUNK;
    }

    public SubChunkPacket touch(Object o) {
        this.subChunks.forEach(AbstractReferenceCounted::touch);
        return this;
    }

    protected void deallocate() {
        this.subChunks.forEach(AbstractReferenceCounted::release);
    }

    @Override
    public SubChunkPacket clone() {
        throw new UnsupportedOperationException("Can not clone reference counted packet");
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public Vector3i getCenterPosition() {
        return this.centerPosition;
    }

    public List<SubChunkData> getSubChunks() {
        return this.subChunks;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public void setCenterPosition(Vector3i centerPosition) {
        this.centerPosition = centerPosition;
    }

    public void setSubChunks(List<SubChunkData> subChunks) {
        this.subChunks = subChunks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubChunkPacket)) {
            return false;
        }
        SubChunkPacket other = (SubChunkPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.cacheEnabled != other.cacheEnabled) {
            return false;
        }
        Vector3i this$centerPosition = this.centerPosition;
        Vector3i other$centerPosition = other.centerPosition;
        if (this$centerPosition == null ? other$centerPosition != null : !this$centerPosition.equals(other$centerPosition)) {
            return false;
        }
        List<SubChunkData> this$subChunks = this.subChunks;
        List<SubChunkData> other$subChunks = other.subChunks;
        return !(this$subChunks == null ? other$subChunks != null : !((Object)this$subChunks).equals(other$subChunks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubChunkPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.dimension;
        result = result * 59 + (this.cacheEnabled ? 79 : 97);
        Vector3i $centerPosition = this.centerPosition;
        result = result * 59 + ($centerPosition == null ? 43 : $centerPosition.hashCode());
        List<SubChunkData> $subChunks = this.subChunks;
        result = result * 59 + ($subChunks == null ? 43 : ((Object)$subChunks).hashCode());
        return result;
    }

    public String toString() {
        return "SubChunkPacket(dimension=" + this.dimension + ", cacheEnabled=" + this.cacheEnabled + ", centerPosition=" + this.centerPosition + ", subChunks=" + this.subChunks + ")";
    }
}

