/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.shaded.protocol.common.util;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface TextConverter {
    public static final Default DEFAULT = new Default();

    default public CharSequence deserialize(String text) {
        return this.deserialize(text, true);
    }

    public CharSequence deserialize(String var1, boolean var2);

    public CharSequence deserializeJson(String var1, boolean var2);

    public CharSequence deserializeWithArguments(String var1, List<String> var2, boolean var3);

    public String serialize(CharSequence var1);

    public String serializeJson(CharSequence var1);

    public String serializeWithArguments(CharSequence var1, List<String> var2);

    public @Nullable Boolean needsTranslation(CharSequence var1);

    public static final class Default
    implements TextConverter {
        @Override
        public CharSequence deserialize(String text, boolean translatable) {
            return text;
        }

        @Override
        public CharSequence deserializeJson(String text, boolean translatable) {
            return text;
        }

        @Override
        public CharSequence deserializeWithArguments(String text, List<String> parameters, boolean translatable) {
            return text;
        }

        @Override
        public String serialize(CharSequence text) {
            return text.toString();
        }

        @Override
        public String serializeJson(CharSequence text) {
            return text.toString();
        }

        @Override
        public String serializeWithArguments(CharSequence text, List<String> parameters) {
            return text.toString();
        }

        @Override
        public Boolean needsTranslation(CharSequence text) {
            return null;
        }

        private Default() {
        }
    }
}

