/*
 * Decompiled with CFR 0.152.
 */
package oxy.toviabedrock.utils.definition;

import java.util.Arrays;
import java.util.Objects;
import org.cloudburstmc.nbt.NbtMap;
import oxy.toviabedrock.shaded.lombok.Generated;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.BlockDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import oxy.toviabedrock.shaded.protocol.bedrock.data.inventory.ItemData;

public final class TOVBItemData
implements ItemData {
    static final String[] EMPTY_ARRAY = new String[0];
    private ItemDefinition definition;
    private final int damage;
    private final int count;
    private final NbtMap tag;
    private final String[] canPlace;
    private final String[] canBreak;
    private final long blockingTicks;
    private final BlockDefinition blockDefinition;
    private boolean usingNetId;
    private int netId;

    public TOVBItemData(ItemDefinition definition, int damage, int count, NbtMap tag, String[] canPlace, String[] canBreak, long blockingTicks, BlockDefinition blockDefinition, boolean hasNetId, int netId) {
        this.definition = definition;
        this.damage = damage;
        this.count = count;
        this.tag = tag;
        this.canPlace = canPlace == null ? EMPTY_ARRAY : canPlace;
        this.canBreak = canBreak == null ? EMPTY_ARRAY : canBreak;
        this.blockingTicks = blockingTicks;
        this.blockDefinition = blockDefinition;
        this.netId = netId;
        this.usingNetId = hasNetId;
    }

    @Override
    public ItemDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public NbtMap getTag() {
        return this.tag;
    }

    @Override
    public String[] getCanPlace() {
        return this.canPlace;
    }

    @Override
    public String[] getCanBreak() {
        return this.canBreak;
    }

    @Override
    public long getBlockingTicks() {
        return this.blockingTicks;
    }

    @Override
    public BlockDefinition getBlockDefinition() {
        return this.blockDefinition;
    }

    @Override
    public boolean isUsingNetId() {
        return this.usingNetId;
    }

    @Override
    public int getNetId() {
        return this.netId;
    }

    @Override
    public void setNetId(int netId) {
        this.netId = netId;
    }

    @Override
    public boolean isValid() {
        return !this.isNull() && this.definition != null && this.definition != ItemDefinition.AIR;
    }

    @Override
    public boolean isNull() {
        return this.count <= 0;
    }

    @Override
    public boolean equals(ItemData other, boolean checkAmount, boolean checkMetadata, boolean checkUserdata) {
        return this.definition == other.getDefinition() && (!checkAmount || this.count == other.getCount()) && (!checkMetadata || this.damage == other.getDamage() && this.blockingTicks == other.getBlockingTicks()) && (!checkUserdata || Objects.equals(this.tag, other.getTag()) && Arrays.equals(this.canPlace, other.getCanPlace()) && Arrays.equals(this.canBreak, other.getCanBreak()));
    }

    @Generated
    public String toString() {
        return "TOVBItemData(definition=" + String.valueOf(this.getDefinition()) + ", damage=" + this.getDamage() + ", count=" + this.getCount() + ", tag=" + String.valueOf(this.getTag()) + ", canPlace=" + Arrays.deepToString(this.getCanPlace()) + ", canBreak=" + Arrays.deepToString(this.getCanBreak()) + ", blockingTicks=" + this.getBlockingTicks() + ", blockDefinition=" + String.valueOf(this.getBlockDefinition()) + ", usingNetId=" + this.isUsingNetId() + ", netId=" + this.getNetId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TOVBItemData)) {
            return false;
        }
        TOVBItemData other = (TOVBItemData)o;
        if (this.getDamage() != other.getDamage()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getBlockingTicks() != other.getBlockingTicks()) {
            return false;
        }
        if (this.isUsingNetId() != other.isUsingNetId()) {
            return false;
        }
        if (this.getNetId() != other.getNetId()) {
            return false;
        }
        ItemDefinition this$definition = this.getDefinition();
        ItemDefinition other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        NbtMap this$tag = this.getTag();
        NbtMap other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCanPlace(), other.getCanPlace())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCanBreak(), other.getCanBreak())) {
            return false;
        }
        BlockDefinition this$blockDefinition = this.getBlockDefinition();
        BlockDefinition other$blockDefinition = other.getBlockDefinition();
        return !(this$blockDefinition == null ? other$blockDefinition != null : !this$blockDefinition.equals(other$blockDefinition));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDamage();
        result = result * 59 + this.getCount();
        long $blockingTicks = this.getBlockingTicks();
        result = result * 59 + (int)($blockingTicks >>> 32 ^ $blockingTicks);
        result = result * 59 + (this.isUsingNetId() ? 79 : 97);
        result = result * 59 + this.getNetId();
        ItemDefinition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        NbtMap $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCanPlace());
        result = result * 59 + Arrays.deepHashCode(this.getCanBreak());
        BlockDefinition $blockDefinition = this.getBlockDefinition();
        result = result * 59 + ($blockDefinition == null ? 43 : $blockDefinition.hashCode());
        return result;
    }
}

