/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter.block;

import com.github.blackjack200.ouranos.converter.BlockStateDictionary;
import com.github.blackjack200.ouranos.converter.block.impl.BlockStateDowngrader766to748;
import com.github.blackjack200.ouranos.converter.block.impl.BlockStateDowngrader786to776;
import com.github.blackjack200.ouranos.converter.block.impl.BlockStateDowngrader818to800;
import com.github.blackjack200.ouranos.converter.block.impl.BlockStateDowngrader844to827;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v766.Bedrock_v766;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v786.Bedrock_v786;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v818.Bedrock_v818;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v844.Bedrock_v844;
import com.github.blackjack200.ouranos.utils.HashUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class BlockHashDowngrader {
    private static final TreeMap<Integer, Processor> CONVERTERS = new TreeMap();

    public static Integer downgradeHash(BlockStateDictionary.Dictionary.BlockEntry entry, int input, int output) {
        Map.Entry mapper;
        int protocolVersion;
        if (input <= output) {
            return entry.latestStateHash();
        }
        Iterator iterator = CONVERTERS.descendingMap().entrySet().iterator();
        while (iterator.hasNext() && (protocolVersion = ((Integer)(mapper = iterator.next()).getKey()).intValue()) >= output) {
            if (protocolVersion > input) continue;
            entry = ((Processor)mapper.getValue()).process(entry);
        }
        return HashUtils.computeBlockStateHash(entry.name(), entry.rawState());
    }

    static {
        CONVERTERS.put(Bedrock_v844.CODEC.getProtocolVersion(), BlockStateDowngrader844to827::downgradeState);
        CONVERTERS.put(Bedrock_v818.CODEC.getProtocolVersion(), BlockStateDowngrader818to800::downgradeState);
        CONVERTERS.put(Bedrock_v786.CODEC.getProtocolVersion(), BlockStateDowngrader786to776::downgradeState);
        CONVERTERS.put(Bedrock_v766.CODEC.getProtocolVersion(), BlockStateDowngrader766to748::downgradeState);
    }

    private static interface Processor {
        public BlockStateDictionary.Dictionary.BlockEntry process(BlockStateDictionary.Dictionary.BlockEntry var1);
    }
}

