/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v291.serializer;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockPacketSerializer;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.EntityEventType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.EntityEventPacket;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.TypeMap;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class EntityEventSerializer_v291
implements BedrockPacketSerializer<EntityEventPacket> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(EntityEventSerializer_v291.class);
    private final TypeMap<EntityEventType> typeMap;

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, EntityEventPacket packet) {
        VarInts.writeUnsignedLong(buffer, packet.getRuntimeEntityId());
        buffer.writeByte(this.typeMap.getId(packet.getType()));
        VarInts.writeInt(buffer, packet.getData());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, EntityEventPacket packet) {
        packet.setRuntimeEntityId(VarInts.readUnsignedLong(buffer));
        short event = buffer.readUnsignedByte();
        packet.setType(this.typeMap.getType(event));
        packet.setData(VarInts.readInt(buffer));
        if (log.isDebugEnabled() && packet.getType() == null) {
            log.debug("Unknown EntityEvent {} in packet {}", (Object)event, (Object)packet);
        }
    }

    public EntityEventSerializer_v291(TypeMap<EntityEventType> typeMap) {
        this.typeMap = typeMap;
    }
}

