/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.CompressionAlgorithm;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.PacketCompressionAlgorithm;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.BedrockBatchWrapper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.BatchCompression;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.CompressionStrategy;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.NoopCompression;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.SnappyCompression;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.ZlibCompression;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.Zlib;

public class SimpleCompressionStrategy
implements CompressionStrategy {
    private final BatchCompression compression;
    private final BatchCompression none;
    private final BatchCompression zlib;
    private final BatchCompression snappy;

    public SimpleCompressionStrategy(BatchCompression compression) {
        this.compression = compression;
        this.none = new NoopCompression();
        if (compression.getAlgorithm() == PacketCompressionAlgorithm.ZLIB) {
            this.zlib = compression;
            this.snappy = new SnappyCompression();
        } else if (compression.getAlgorithm() == PacketCompressionAlgorithm.SNAPPY) {
            this.zlib = new ZlibCompression(Zlib.RAW);
            this.snappy = compression;
        } else {
            this.zlib = new ZlibCompression(Zlib.RAW);
            this.snappy = new SnappyCompression();
        }
    }

    @Override
    public BatchCompression getCompression(BedrockBatchWrapper wrapper) {
        return this.compression;
    }

    @Override
    public BatchCompression getCompression(CompressionAlgorithm algorithm) {
        if (algorithm == PacketCompressionAlgorithm.ZLIB) {
            return this.zlib;
        }
        if (algorithm == PacketCompressionAlgorithm.SNAPPY) {
            return this.snappy;
        }
        if (algorithm == PacketCompressionAlgorithm.NONE) {
            return this.none;
        }
        return this.compression;
    }

    @Override
    public BatchCompression getDefaultCompression() {
        return this.compression;
    }
}

