/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.translators;

import com.github.blackjack200.ouranos.ProtocolInfo;
import com.github.blackjack200.ouranos.base.ProtocolToProtocol;
import com.github.blackjack200.ouranos.base.WrappedBedrockPacket;
import com.github.blackjack200.ouranos.converter.biome.BiomeDefinitionRegistry;
import com.github.blackjack200.ouranos.session.OuranosSession;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v800.Bedrock_v800;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.biome.BiomeDefinitionData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.biome.BiomeDefinitions;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.EntityDataMap;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.EntityDataType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.EntityFlag;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddEntityPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddItemEntityPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddPlayerPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BiomeDefinitionListPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ClientCacheStatusPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.PlayerListPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.PlayerSkinPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ResourcePackStackPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.SetEntityDataPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.StartGamePacket;
import com.github.blackjack200.ouranos.translators.global_storage.EntityMetadataStorage;
import java.awt.Color;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;

public class GlobalProtocolTranslator
extends ProtocolToProtocol {
    @Override
    public void init(OuranosSession session) {
        session.put(new EntityMetadataStorage(session));
    }

    @Override
    protected void registerProtocol() {
        this.registerClientbound(StartGamePacket.class, wrapped -> {
            StartGamePacket packet = (StartGamePacket)wrapped.getPacket();
            packet.setBlockRegistryChecksum(0L);
        });
        this.registerClientbound(ResourcePackStackPacket.class, wrapped -> {
            ResourcePackStackPacket packet = (ResourcePackStackPacket)wrapped.getPacket();
            packet.setGameVersion(ProtocolInfo.getPacketCodec(wrapped.session().getProtocolId()).getMinecraftVersion());
        });
        this.registerServerbound(ClientCacheStatusPacket.class, wrapped -> {
            ClientCacheStatusPacket packet = (ClientCacheStatusPacket)wrapped.getPacket();
            packet.setSupported(false);
        });
        this.registerClientbound(BiomeDefinitionListPacket.class, wrapped -> {
            BiomeDefinitionListPacket packet = (BiomeDefinitionListPacket)wrapped.getPacket();
            if (wrapped.getOutput() >= Bedrock_v800.CODEC.getProtocolVersion() && packet.getDefinitions() != null) {
                BiomeDefinitions defs = new BiomeDefinitions(new HashMap<String, BiomeDefinitionData>());
                packet.getDefinitions().forEach((id, n) -> {
                    BiomeDefinitionData def = BiomeDefinitionRegistry.getInstance(wrapped.getInput()).fromStringId((String)id);
                    if (def != null) {
                        defs.getDefinitions().put((String)id, def);
                    }
                });
                packet.setBiomes(defs);
                return;
            }
            if (packet.getBiomes() != null && packet.getDefinitions() == null) {
                packet.setDefinitions(this.downgradeBiomeDefinition(wrapped.getOutput(), packet.getBiomes().getDefinitions()));
            }
        });
        this.registerClientbound(SetEntityDataPacket.class, wrapped -> {
            EntityMetadataStorage storage = wrapped.session().get(EntityMetadataStorage.class);
            if (storage == null) {
                return;
            }
            SetEntityDataPacket packet = (SetEntityDataPacket)wrapped.getPacket();
            packet.setMetadata(this.cleanMetadata(storage, packet.getMetadata()));
        });
        this.registerClientbound(AddEntityPacket.class, wrapped -> {
            EntityMetadataStorage storage = wrapped.session().get(EntityMetadataStorage.class);
            if (storage == null) {
                return;
            }
            AddEntityPacket packet = (AddEntityPacket)wrapped.getPacket();
            packet.setMetadata(this.cleanMetadata(storage, packet.getMetadata()));
        });
        this.registerClientbound(AddPlayerPacket.class, wrapped -> {
            EntityMetadataStorage storage = wrapped.session().get(EntityMetadataStorage.class);
            if (storage == null) {
                return;
            }
            AddPlayerPacket packet = (AddPlayerPacket)wrapped.getPacket();
            packet.setMetadata(this.cleanMetadata(storage, packet.getMetadata()));
        });
        this.registerClientbound(AddItemEntityPacket.class, wrapped -> {
            EntityMetadataStorage storage = wrapped.session().get(EntityMetadataStorage.class);
            if (storage == null) {
                return;
            }
            AddItemEntityPacket packet = (AddItemEntityPacket)wrapped.getPacket();
            packet.setMetadata(this.cleanMetadata(storage, packet.getMetadata()));
        });
        this.registerClientbound(PlayerListPacket.class, wrapped -> {
            PlayerListPacket packet = (PlayerListPacket)wrapped.getPacket();
            for (PlayerListPacket.Entry entry : packet.getEntries()) {
                entry.setColor(Objects.requireNonNullElse(entry.getColor(), Color.WHITE));
                if (entry.getSkin() == null) continue;
                entry.setSkin(entry.getSkin().toBuilder().geometryDataEngineVersion(ProtocolInfo.getPacketCodec(wrapped.getOutput()).getMinecraftVersion()).build());
            }
        });
        Consumer<WrappedBedrockPacket> playerSkinConsumer = wrapped -> {
            PlayerSkinPacket packet = (PlayerSkinPacket)wrapped.getPacket();
            packet.setSkin(packet.getSkin().toBuilder().geometryDataEngineVersion(ProtocolInfo.getPacketCodec(wrapped.getOutput()).getMinecraftVersion()).build());
        };
        this.registerClientbound(PlayerSkinPacket.class, playerSkinConsumer);
        this.registerServerbound(PlayerSkinPacket.class, playerSkinConsumer);
    }

    private EntityDataMap cleanMetadata(EntityMetadataStorage storage, EntityDataMap metadata) {
        if (metadata == null) {
            return null;
        }
        EntityDataMap newMetadata = new EntityDataMap();
        try {
            for (EntityDataType<?> type : metadata.keySet()) {
                if (storage.getDataTypeMap().fromType(type) == null) continue;
                newMetadata.put(type, metadata.get(type));
            }
            EnumSet<EntityFlag> flags = newMetadata.getFlags();
            if (flags != null) {
                flags.removeIf(flag -> storage.getFlags().getIdUnsafe((EntityFlag)((Object)flag)) == -1 && storage.getFlags_2().getIdUnsafe((EntityFlag)((Object)flag)) == -1);
            }
        }
        catch (Exception exception) {
            return metadata;
        }
        return newMetadata;
    }

    private NbtMap downgradeBiomeDefinition(int output, Map<String, BiomeDefinitionData> definitions) {
        NbtMapBuilder builder = NbtMap.builder();
        if (definitions.isEmpty()) {
            definitions = BiomeDefinitionRegistry.getInstance(output).getEntries();
        }
        definitions.forEach((id, def) -> {
            NbtMapBuilder d = NbtMap.builder();
            d.putString("name_hash", id);
            d.putFloat("temperature", def.getTemperature());
            d.putFloat("downfall", def.getDownfall());
            d.putBoolean("rain", def.isRain());
            builder.putCompound(id, d.build());
        });
        return builder.build();
    }
}

