/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.translators.new_to_old.v419to408;

import com.github.blackjack200.ouranos.base.ProtocolToProtocol;
import com.github.blackjack200.ouranos.converter.BlockStateDictionary;
import com.github.blackjack200.ouranos.data.LegacyBlockIdToStringIdMap;
import com.github.blackjack200.ouranos.session.OuranosSession;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseStatus;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddEntityPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddItemEntityPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddPaintingPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddPlayerPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ItemStackResponsePacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.MoveEntityDeltaPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.MovePlayerPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.PlayerAuthInputPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.RemoveEntityPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.StartGamePacket;
import com.github.blackjack200.ouranos.translators.new_to_old.v419to408.tracker.EntityTracker_v419;
import java.util.List;
import java.util.Objects;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;

public class Protocol419to408
extends ProtocolToProtocol {
    @Override
    public void init(OuranosSession session) {
        session.put(new EntityTracker_v419(session));
    }

    @Override
    protected void registerProtocol() {
        this.registerClientbound(ItemStackResponsePacket.class, wrapped -> {
            ItemStackResponsePacket packet = (ItemStackResponsePacket)wrapped.getPacket();
            packet.getEntries().replaceAll(entry -> new ItemStackResponse(entry.getResult().equals((Object)ItemStackResponseStatus.OK), entry.getRequestId(), entry.getContainers()));
        });
        this.registerClientbound(StartGamePacket.class, wrapped -> {
            StartGamePacket packet = (StartGamePacket)wrapped.getPacket();
            List<NbtMap> states = BlockStateDictionary.getInstance(wrapped.getOutput()).getKnownStates().stream().map(e -> {
                short legacyId = (short)(Objects.requireNonNullElse(LegacyBlockIdToStringIdMap.getInstance().fromString(wrapped.getOutput(), e.name()), 255) & 0xFFFFFFF);
                return NbtMap.builder().putCompound("block", e.rawState()).putShort("id", legacyId).build();
            }).toList();
            packet.setBlockPalette((NbtList<NbtMap>)new NbtList(NbtType.COMPOUND, states));
        });
        this.registerServerbound(PlayerAuthInputPacket.class, wrapped -> {
            PlayerAuthInputPacket packet = (PlayerAuthInputPacket)wrapped.getPacket();
            packet.setDelta(Vector3f.ZERO);
        });
        this.registerClientbound(RemoveEntityPacket.class, wrapped -> {
            RemoveEntityPacket packet = (RemoveEntityPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v419.class).remove(packet.getUniqueEntityId());
        });
        this.registerClientbound(AddPaintingPacket.class, wrapped -> {
            AddPaintingPacket packet = (AddPaintingPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v419.class).cache(packet.getRuntimeEntityId(), packet.getUniqueEntityId(), packet.getPosition(), Vector3f.ZERO);
        });
        this.registerClientbound(AddItemEntityPacket.class, wrapped -> {
            AddItemEntityPacket packet = (AddItemEntityPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v419.class).cache(packet.getRuntimeEntityId(), packet.getUniqueEntityId(), packet.getPosition(), Vector3f.ZERO);
        });
        this.registerClientbound(AddPlayerPacket.class, wrapped -> {
            AddPlayerPacket packet = (AddPlayerPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v419.class).cache(packet.getRuntimeEntityId(), packet.getUniqueEntityId(), packet.getPosition(), packet.getRotation());
        });
        this.registerClientbound(AddEntityPacket.class, wrapped -> {
            AddEntityPacket packet = (AddEntityPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v419.class).cache(packet.getRuntimeEntityId(), packet.getUniqueEntityId(), packet.getPosition(), Vector3f.from((float)packet.getRotation().getX(), (float)packet.getRotation().getY(), (float)packet.getRotation().getY()));
        });
        this.registerClientbound(MovePlayerPacket.class, wrapped -> {
            MovePlayerPacket packet = (MovePlayerPacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v419.class).moveAbsolute(packet.getRuntimeEntityId(), packet.getPosition(), packet.getRotation());
        });
        this.registerClientbound(MoveEntityAbsolutePacket.class, wrapped -> {
            MoveEntityAbsolutePacket packet = (MoveEntityAbsolutePacket)wrapped.getPacket();
            wrapped.session().get(EntityTracker_v419.class).moveAbsolute(packet.getRuntimeEntityId(), packet.getPosition(), packet.getRotation());
        });
        this.registerClientbound(MoveEntityDeltaPacket.class, wrapped -> {
            MoveEntityDeltaPacket packet;
            EntityTracker_v419 entityTracker = wrapped.session().get(EntityTracker_v419.class);
            EntityTracker_v419.EntityCache entity = entityTracker.getEntity((packet = (MoveEntityDeltaPacket)wrapped.getPacket()).getRuntimeEntityId());
            if (entity == null) {
                return;
            }
            packet.setX((float)Math.round((double)packet.getX() * 100.0) / 100.0f);
            packet.setY((float)Math.round((double)packet.getY() * 100.0) / 100.0f);
            packet.setZ((float)Math.round((double)packet.getZ() * 100.0) / 100.0f);
            packet.setDeltaX(this.toIntDelta(packet.getX(), entity.getPosition().getX()));
            packet.setDeltaY(this.toIntDelta(packet.getY(), entity.getPosition().getY()));
            packet.setDeltaZ(this.toIntDelta(packet.getZ(), entity.getPosition().getZ()));
            entityTracker.moveRelative(entity, packet);
        });
    }

    private int toIntDelta(float current, float prev) {
        return Float.floatToIntBits((float)Math.round((double)current * 100.0) / 100.0f) - Float.floatToIntBits((float)Math.round((double)prev * 100.0) / 100.0f);
    }
}

