/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.handler;

import com.github.blackjack200.ouranos.ProtocolInfo;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v575.Bedrock_v575;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v589.Bedrock_v589;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.raphimc.minecraftauth.bedrock.model.MinecraftMultiplayerToken;
import net.raphimc.minecraftauth.msa.model.MsaDeviceCode;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.compat.BedrockCompat;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.ClientboundCloseFormPacket;
import org.cloudburstmc.protocol.bedrock.packet.LoginPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.RequestNetworkSettingsPacket;
import org.cloudburstmc.protocol.bedrock.packet.ResourcePackClientResponsePacket;
import org.cloudburstmc.protocol.bedrock.packet.ResourcePacksInfoPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetLocalPlayerAsInitializedPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetTimePacket;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.geysermc.event.Event;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.event.bedrock.SessionInitializeEvent;
import org.geysermc.geyser.event.type.SessionLoadResourcePacksEventImpl;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.AuthData;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.LoginEncryptionUtils;
import oxy.geyser.reversion.DuplicatedProtocolInfo;
import oxy.geyser.reversion.GeyserReversion;
import oxy.geyser.reversion.handler.duplicated.UpstreamPacketHandler;
import oxy.geyser.reversion.session.GeyserTranslatedUser;
import oxy.geyser.reversion.util.ClientDataUtil;
import oxy.geyser.reversion.util.GeyserUtil;
import oxy.geyser.reversion.util.PendingBedrockAuthentication;

public final class TranslatorPacketHandler
extends UpstreamPacketHandler {
    private GeyserTranslatedUser user;
    private int clientProtocol = -1;

    public TranslatorPacketHandler(GeyserImpl geyser, GeyserSession session) {
        super(geyser, session);
    }

    @Override
    public PacketSignal handle(RequestNetworkSettingsPacket packet) {
        boolean needTranslation;
        if (this.checkCodec(packet.getProtocolVersion())) {
            return PacketSignal.HANDLED;
        }
        this.clientProtocol = packet.getProtocolVersion();
        boolean bl = needTranslation = GameProtocol.getBedrockCodec((int)this.clientProtocol) == null;
        if (needTranslation) {
            packet.setProtocolVersion(GeyserReversion.OLDEST_GEYSER_CODEC.getProtocolVersion());
        }
        super.handle(packet);
        if (needTranslation) {
            this.session.getUpstream().getSession().setCodec(DuplicatedProtocolInfo.getPacketCodec(this.clientProtocol));
        }
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(LoginPacket packet) {
        int pv;
        if (this.clientProtocol == -1) {
            this.clientProtocol = packet.getProtocolVersion();
        }
        if (this.checkCodec(pv = packet.getProtocolVersion())) {
            return PacketSignal.HANDLED;
        }
        if (GameProtocol.getBedrockCodec((int)pv) == null) {
            this.user = new GeyserTranslatedUser(pv, GeyserReversion.OLDEST_GEYSER_CODEC.getProtocolVersion(), this.session);
            packet.setProtocolVersion(GeyserReversion.OLDEST_GEYSER_CODEC.getProtocolVersion());
            this.session.getUpstream().getSession().setCodec(DuplicatedProtocolInfo.getPacketCodec(this.clientProtocol));
            GeyserUtil.hook(this.session);
        }
        if (this.clientProtocol < Bedrock_v589.CODEC.getProtocolVersion()) {
            if (this.geyser.isShuttingDown() || this.geyser.isReloading()) {
                this.session.disconnect(GeyserLocale.getLocaleStringLog((String)"geyser.core.shutdown.kick.message"));
                return PacketSignal.HANDLED;
            }
            if (this.geyser.getSessionManager().reachedMaxConnectionsPerAddress(this.session)) {
                this.session.disconnect("Too many connections are originating from this location!");
                return PacketSignal.HANDLED;
            }
            this.session.setBlockMappings((BlockMappings)BlockRegistries.BLOCKS.forVersion(packet.getProtocolVersion()));
            this.session.setItemMappings((ItemMappings)Registries.ITEMS.forVersion(packet.getProtocolVersion()));
            ClientDataUtil.setClientData(this.session, packet);
            if (this.session.isClosed()) {
                return PacketSignal.HANDLED;
            }
            PlayStatusPacket playStatus = new PlayStatusPacket();
            playStatus.setStatus(PlayStatusPacket.Status.LOGIN_SUCCESS);
            this.session.sendUpstreamPacket((BedrockPacket)playStatus);
            this.resourcePackLoadEvent = new SessionLoadResourcePacksEventImpl(this.session);
            this.geyser.eventBus().fireEventElseKick((Event)this.resourcePackLoadEvent, this.session);
            if (this.session.isClosed()) {
                return PacketSignal.HANDLED;
            }
            ResourcePacksInfoPacket resourcePacksInfo = new ResourcePacksInfoPacket();
            resourcePacksInfo.getResourcePackInfos().addAll(this.resourcePackLoadEvent.infoPacketEntries());
            resourcePacksInfo.setVibrantVisualsForceDisabled(!this.session.isAllowVibrantVisuals());
            resourcePacksInfo.setForcedToAccept(GeyserImpl.getInstance().config().gameplay().forceResourcePacks());
            resourcePacksInfo.setWorldTemplateId(UUID.randomUUID());
            resourcePacksInfo.setWorldTemplateVersion("*");
            this.session.sendUpstreamPacket((BedrockPacket)resourcePacksInfo);
            GeyserLocale.loadGeyserLocale((String)this.session.locale());
            return PacketSignal.HANDLED;
        }
        super.handle(packet);
        if (this.user != null) {
            this.user.setAuthenticated(true);
        }
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(ResourcePackClientResponsePacket packet) {
        if (this.session.getUpstream().isClosed() || this.session.isClosed()) {
            return PacketSignal.HANDLED;
        }
        if (this.clientProtocol >= Bedrock_v589.CODEC.getProtocolVersion() || packet.getStatus() != ResourcePackClientResponsePacket.Status.COMPLETED) {
            return super.handle(packet);
        }
        if (this.finishedResourcePackSending) {
            this.session.disconnect("Illegal duplicate resource pack response packet received!");
            return PacketSignal.HANDLED;
        }
        this.finishedResourcePackSending = true;
        this.session.connect();
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(SetLocalPlayerAsInitializedPacket packet) {
        if (this.user != null && !this.user.isAuthenticated()) {
            this.authenticate();
        }
        return super.handle(packet);
    }

    private void authenticate() {
        SetTimePacket packet = new SetTimePacket();
        packet.setTime(16000);
        this.session.sendUpstreamPacket((BedrockPacket)packet);
        PendingBedrockAuthentication.AuthenticationTask task = GeyserReversion.AUTH.getOrCreateTask(this.session.getAuthData().xuid() + "-" + String.valueOf(this.session.getAuthData().uuid()) + "-" + this.session.getAuthData().name());
        if (task.getAuthentication() != null && task.getAuthentication().isDone()) {
            this.onMicrosoftLoginComplete(task);
        } else {
            task.resetRunningFlow();
            task.performLoginAttempt(code -> {
                if (!this.session.isClosed()) {
                    LoginEncryptionUtils.buildAndShowMicrosoftCodeWindow((GeyserSession)this.session, (MsaDeviceCode)code);
                }
            }).handle((T r, U e) -> this.onMicrosoftLoginComplete(task));
        }
    }

    public boolean onMicrosoftLoginComplete(PendingBedrockAuthentication.AuthenticationTask task) {
        if (this.session.isClosed()) {
            return true;
        }
        task.cleanup();
        return ((CompletableFuture)task.getAuthentication().handle((T result, U ex) -> {
            this.session.closeForm();
            this.session.sendUpstreamPacket((BedrockPacket)new ClientboundCloseFormPacket());
            MinecraftMultiplayerToken token = (MinecraftMultiplayerToken)result.getMinecraftMultiplayerToken().getCached();
            this.session.setAuthData(new AuthData(token.getDisplayName(), token.getUuid(), token.getXuid(), this.session.getAuthData().issuedAt()));
            this.geyser.getSessionManager().addPendingSession(this.session);
            this.geyser.eventBus().fire((Object)new SessionInitializeEvent((GeyserConnection)this.session));
            this.user.setAuthenticated(true);
            this.session.authenticate(this.session.getAuthData().name());
            return true;
        })).getNow(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketSignal handlePacket(BedrockPacket packet) {
        if (this.user == null) {
            super.handlePacket(packet);
            return PacketSignal.HANDLED;
        }
        ByteBuf input = Unpooled.buffer();
        ByteBuf output = Unpooled.buffer();
        try {
            this.user.encodeClient(packet, input);
            int oldId = this.user.getCloudburstClientCodec().getPacketDefinition(packet.getClass()).getId();
            Integer newId = this.user.translateServerbound(input, output, oldId);
            if (newId == null) {
                PacketSignal packetSignal = PacketSignal.HANDLED;
                return packetSignal;
            }
            super.handlePacket(this.user.decodeServer(output, newId));
        }
        catch (Exception exception) {
            if (GeyserReversion.CONFIG.debugMode()) {
                GeyserReversion.LOGGER.severe("Failed to translate " + String.valueOf(packet.getPacketType()) + " (serverbound)!", (Throwable)exception);
            }
        }
        finally {
            input.release();
            output.release();
        }
        return PacketSignal.HANDLED;
    }

    private boolean checkCodec(int protocolVersion) {
        BedrockCodec codec;
        int minProtocolVer = GeyserReversion.CONFIG.minProtocolId();
        if (GeyserReversion.INJECTION_FAILED) {
            minProtocolVer = Math.max(Bedrock_v575.CODEC.getProtocolVersion(), minProtocolVer);
        }
        if (minProtocolVer != -1 && (codec = DuplicatedProtocolInfo.getPacketCodec(minProtocolVer)) != null && protocolVersion < minProtocolVer) {
            this.session.getUpstream().getSession().setCodec(BedrockCompat.disconnectCompat((int)protocolVersion));
            this.session.disconnect(GeyserReversion.CONFIG.minProtocolKick().replace("%version%", codec.getMinecraftVersion()));
            return true;
        }
        List<Integer> blockProtocols = GeyserReversion.CONFIG.blockProtocols();
        if (blockProtocols != null && blockProtocols.contains(protocolVersion)) {
            this.session.getUpstream().getSession().setCodec(BedrockCompat.disconnectCompat((int)protocolVersion));
            this.session.disconnect(GeyserReversion.CONFIG.blockedProtocolKick());
            return true;
        }
        if (ProtocolInfo.getPacketCodec(protocolVersion) == null && GameProtocol.getBedrockCodec((int)protocolVersion) == null) {
            this.session.getUpstream().getSession().setCodec(BedrockCompat.disconnectCompat((int)protocolVersion));
            this.session.disconnect(GeyserReversion.CONFIG.versionNotSupportedKick());
            return true;
        }
        return false;
    }

    @Generated
    public GeyserTranslatedUser getUser() {
        return this.user;
    }
}

