/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.targets;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.tree.AbstractInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.classtransform.TransformerManager;
import oxy.geyser.reversion.shaded.classtransform.annotations.CSlice;
import oxy.geyser.reversion.shaded.classtransform.annotations.CTarget;
import oxy.geyser.reversion.shaded.classtransform.exceptions.SliceException;
import oxy.geyser.reversion.shaded.classtransform.mappings.AMapper;
import oxy.geyser.reversion.shaded.classtransform.mappings.annotation.RemapType;
import oxy.geyser.reversion.shaded.classtransform.mappings.dynamic.IDynamicRemapper;

@ParametersAreNonnullByDefault
public interface IInjectionTarget
extends IDynamicRemapper {
    public List<AbstractInsnNode> getTargets(Map<String, IInjectionTarget> var1, MethodNode var2, CTarget var3, @Nullable CSlice var4);

    default public CTarget.Shift getShift(CTarget target) {
        return target.shift();
    }

    default public List<AbstractInsnNode> getSlice(Map<String, IInjectionTarget> injectionTargets, MethodNode method, @Nullable CSlice slice) {
        int to;
        List<AbstractInsnNode> targets;
        IInjectionTarget target;
        int from;
        if (slice == null) {
            return Arrays.asList(method.instructions.toArray());
        }
        if (slice.from().value().isEmpty()) {
            from = 0;
        } else {
            target = injectionTargets.get(slice.from().value().toUpperCase(Locale.ROOT));
            if (target == null) {
                throw SliceException.unknown("from", slice.from().value());
            }
            targets = target.getTargets(injectionTargets, method, slice.from(), null);
            if (targets.size() != 1) {
                throw SliceException.count("From", slice.from().value(), targets.size());
            }
            from = method.instructions.indexOf(targets.get(0));
        }
        if (slice.to().value().isEmpty()) {
            to = method.instructions.size();
        } else {
            target = injectionTargets.get(slice.to().value().toUpperCase(Locale.ROOT));
            if (target == null) {
                throw SliceException.unknown("to", slice.to().value());
            }
            targets = target.getTargets(injectionTargets, method, slice.to(), null);
            if (targets.size() != 1) {
                throw SliceException.count("To", slice.to().value(), targets.size());
            }
            to = method.instructions.indexOf(targets.get(0));
        }
        ArrayList<AbstractInsnNode> instructions = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode instruction : method.instructions) {
            instructions.add(instruction);
        }
        Iterator it = instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode instruction;
            instruction = (AbstractInsnNode)it.next();
            int index = method.instructions.indexOf(instruction);
            if (index >= from && index <= to) continue;
            it.remove();
        }
        return instructions;
    }

    @Override
    @Nullable
    default public RemapType dynamicRemap(AMapper mapper, Class<?> annotation, Map<String, Object> values, Method remappedMethod, TransformerManager transformerManager, ClassNode target, ClassNode transformer) {
        return RemapType.MEMBER;
    }
}

