/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.text.csv;

import com.github.blackjack200.ouranos.shaded.hutool.core.collection.ComputeIter;
import com.github.blackjack200.ouranos.shaded.hutool.core.io.IORuntimeException;
import com.github.blackjack200.ouranos.shaded.hutool.core.map.MapUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.text.csv.CsvReadConfig;
import com.github.blackjack200.ouranos.shaded.hutool.core.text.csv.CsvRow;
import com.github.blackjack200.ouranos.shaded.hutool.core.text.csv.CsvTokener;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.ObjUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public final class CsvParser
extends ComputeIter<CsvRow>
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_ROW_CAPACITY = 10;
    private final CsvReadConfig config;
    private final CsvTokener tokener;
    private int preChar = -1;
    private boolean inQuotes;
    private final StringBuilder currentField = new StringBuilder(512);
    private CsvRow header;
    private long lineNo = -1L;
    private long inQuotesLineCount;
    private int firstLineFieldCount = -1;
    private int maxFieldCount;
    private boolean finished;

    public CsvParser(Reader reader, CsvReadConfig config) {
        this.config = ObjUtil.defaultIfNull(config, CsvReadConfig::defaultConfig);
        this.tokener = new CsvTokener(reader);
    }

    public List<String> getHeader() {
        if (this.config.headerLineNo < 0L) {
            throw new IllegalStateException("No header available - header parsing is disabled");
        }
        if (this.lineNo < this.config.beginLineNo) {
            throw new IllegalStateException("No header available - call nextRow() first");
        }
        return this.header.getRawList();
    }

    @Override
    protected CsvRow computeNext() {
        return this.nextRow();
    }

    public CsvRow nextRow() throws IORuntimeException {
        List<String> currentFields;
        int fieldCount;
        while (!this.finished && (fieldCount = (currentFields = this.readLine()).size()) >= 1) {
            if (this.lineNo < this.config.beginLineNo) continue;
            if (this.lineNo > this.config.endLineNo) break;
            if (this.config.skipEmptyRows && fieldCount == 1 && currentFields.get(0).isEmpty()) continue;
            if (this.config.errorOnDifferentFieldCount) {
                if (this.firstLineFieldCount < 0) {
                    this.firstLineFieldCount = fieldCount;
                } else if (fieldCount != this.firstLineFieldCount) {
                    throw new IORuntimeException(String.format("Line %d has %d fields, but first line has %d fields", this.lineNo, fieldCount, this.firstLineFieldCount));
                }
            }
            if (fieldCount > this.maxFieldCount) {
                this.maxFieldCount = fieldCount;
            }
            if (this.lineNo == this.config.headerLineNo && null == this.header) {
                this.initHeader(currentFields);
                continue;
            }
            return new CsvRow(this.lineNo, null == this.header ? null : this.header.headerMap, currentFields);
        }
        return null;
    }

    private void initHeader(List<String> currentFields) {
        LinkedHashMap<String, Integer> localHeaderMap = new LinkedHashMap<String, Integer>(currentFields.size());
        for (int i = 0; i < currentFields.size(); ++i) {
            String field = currentFields.get(i);
            if (MapUtil.isNotEmpty(this.config.headerAlias)) {
                field = ObjUtil.defaultIfNull(this.config.headerAlias.get(field), field);
            }
            if (!StrUtil.isNotEmpty(field) || localHeaderMap.containsKey(field)) continue;
            localHeaderMap.put(field, i);
        }
        this.header = new CsvRow(this.lineNo, Collections.unmodifiableMap(localHeaderMap), Collections.unmodifiableList(currentFields));
    }

    private List<String> readLine() throws IORuntimeException {
        if (this.inQuotesLineCount > 0L) {
            this.lineNo += this.inQuotesLineCount;
            this.inQuotesLineCount = 0L;
        }
        ArrayList<String> currentFields = new ArrayList<String>(this.maxFieldCount > 0 ? this.maxFieldCount : 10);
        StringBuilder currentField = this.currentField;
        int preChar = this.preChar;
        boolean inComment = false;
        while (true) {
            int c;
            if ((c = this.tokener.next()) < 0) {
                if (currentField.length() > 0 || preChar == this.config.fieldSeparator) {
                    if (this.inQuotes) {
                        currentField.append(this.config.textDelimiter);
                    }
                    this.addField(currentFields, currentField.toString());
                    currentField.setLength(0);
                }
                this.finished = true;
                break;
            }
            if (!(preChar >= 0 && preChar != 13 && preChar != 10 || this.inQuotes || null == this.config.commentCharacter || c != this.config.commentCharacter.charValue())) {
                inComment = true;
            }
            if (inComment) {
                if (c != 13 && c != 10) continue;
                ++this.lineNo;
                inComment = false;
                continue;
            }
            if (this.inQuotes) {
                if (c == this.config.textDelimiter) {
                    int next = this.tokener.next();
                    if (next != this.config.textDelimiter) {
                        this.inQuotes = false;
                        this.tokener.back();
                    }
                } else if (this.isLineEnd(c, preChar)) {
                    ++this.inQuotesLineCount;
                }
                currentField.append((char)c);
            } else if (c == this.config.fieldSeparator) {
                this.addField(currentFields, currentField.toString());
                currentField.setLength(0);
            } else if (c == this.config.textDelimiter && this.isFieldBegin(preChar)) {
                this.inQuotes = true;
                currentField.append((char)c);
            } else {
                if (c == 13) {
                    this.addField(currentFields, currentField.toString());
                    currentField.setLength(0);
                    preChar = c;
                    break;
                }
                if (c == 10) {
                    if (preChar != 13) {
                        this.addField(currentFields, currentField.toString());
                        currentField.setLength(0);
                        preChar = c;
                        break;
                    }
                } else {
                    currentField.append((char)c);
                }
            }
            preChar = c;
        }
        this.preChar = preChar;
        ++this.lineNo;
        return currentFields;
    }

    @Override
    public void close() throws IOException {
        this.tokener.close();
    }

    private void addField(List<String> currentFields, String field) {
        char textDelimiter = this.config.textDelimiter;
        if (StrUtil.isWrap((CharSequence)(field = StrUtil.trim(field, 1, c -> c.charValue() == '\n' || c.charValue() == '\r')), textDelimiter)) {
            field = StrUtil.sub(field, 1, field.length() - 1);
        }
        if (this.config.trimField) {
            field = StrUtil.trim(field);
        }
        currentFields.add(field);
    }

    private boolean isLineEnd(int c, int preChar) {
        return (c == 13 || c == 10) && preChar != 13;
    }

    private boolean isFieldBegin(int preChar) {
        return preChar == -1 || preChar == this.config.fieldSeparator || preChar == 10 || preChar == 13;
    }
}

