/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import org.geysermc.geyser.api.extension.Extension;
import oxy.geyser.reversion.shaded.jackson.databind.DeserializationFeature;
import oxy.geyser.reversion.shaded.jackson.databind.ObjectMapper;
import oxy.geyser.reversion.shaded.jackson.dataformat.yaml.YAMLFactory;

public class ConfigLoader {
    public static <T> T load(Extension extension, Class<?> extensionClass, Class<T> configClass) {
        File configFile = extension.dataFolder().resolve("config.yml").toFile();
        if (!extension.dataFolder().toFile().exists() && !extension.dataFolder().toFile().mkdirs()) {
            extension.logger().error("Failed to create data folder");
            return null;
        }
        if (!configFile.exists()) {
            try (FileWriter writer = new FileWriter(configFile);
                 FileSystem fileSystem = FileSystems.newFileSystem(new File(extensionClass.getProtectionDomain().getCodeSource().getLocation().toURI()).toPath(), Collections.emptyMap());
                 InputStream input = Files.newInputStream(fileSystem.getPath("config.yml", new String[0]), new OpenOption[0]);){
                byte[] bytes = new byte[input.available()];
                input.read(bytes);
                writer.write(new String(bytes).toCharArray());
                writer.flush();
            }
            catch (IOException | URISyntaxException e) {
                extension.logger().error("Failed to create config", (Throwable)e);
                return null;
            }
        }
        try {
            return new ObjectMapper(new YAMLFactory()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES).disable(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES).readValue(configFile, configClass);
        }
        catch (IOException e) {
            extension.logger().error("Failed to load config", (Throwable)e);
            return null;
        }
    }
}

