/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter;

import com.github.blackjack200.ouranos.data.AbstractMapping;
import com.github.blackjack200.ouranos.data.ItemTypeInfo;
import com.github.blackjack200.ouranos.shaded.gson.Gson;
import com.github.blackjack200.ouranos.shaded.gson.reflect.TypeToken;
import com.github.blackjack200.ouranos.shaded.lombok.Generated;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v408.Bedrock_v408;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ItemTypeDictionary
extends AbstractMapping {
    private static final ItemTypeDictionary instance = new ItemTypeDictionary();
    private static final Map<Integer, InnerEntry> entries = new ConcurrentHashMap<Integer, InnerEntry>();

    private ItemTypeDictionary() {
    }

    public static InnerEntry getInstance(int protocolId) {
        return entries.computeIfAbsent(protocolId, protocol -> {
            if (protocol > Bedrock_v408.CODEC.getProtocolVersion()) {
                try (InputStream requiredItemList = ItemTypeDictionary.open(ItemTypeDictionary.lookupAvailableFile("required_item_list.json", protocol));){
                    InnerEntry innerEntry;
                    try (InputStreamReader reader = new InputStreamReader(requiredItemList);){
                        innerEntry = new InnerEntry((Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, ItemTypeInfo>>(){}.getType()));
                    }
                    return innerEntry;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try (InputStream itemIdMap = ItemTypeDictionary.open(ItemTypeDictionary.lookupAvailableFile("item_id_map.json", protocol));){
                InnerEntry innerEntry;
                try (InputStreamReader reader = new InputStreamReader(itemIdMap);){
                    Map rawEntries = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, Integer>>(){}.getType());
                    HashMap<String, ItemTypeInfo> entries = new HashMap<String, ItemTypeInfo>(rawEntries.size());
                    rawEntries.forEach((key, value) -> entries.put((String)key, new ItemTypeInfo((int)value, false, ItemVersion.LEGACY.ordinal(), null)));
                    innerEntry = new InnerEntry(entries);
                }
                return innerEntry;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Generated
    public static ItemTypeDictionary getInstance() {
        return instance;
    }

    public static class InnerEntry {
        private final Map<String, Integer> stringToRuntimeId;
        private final Map<Integer, String> runtimeIdToString;
        private final Map<String, ItemTypeInfo> allEntries;

        private InnerEntry(Map<String, ItemTypeInfo> entries) {
            this.allEntries = entries;
            this.stringToRuntimeId = new ConcurrentHashMap<String, Integer>();
            this.runtimeIdToString = new ConcurrentHashMap<Integer, String>();
            this.allEntries.forEach((stringId, info) -> {
                this.stringToRuntimeId.put((String)stringId, info.runtime_id());
                this.runtimeIdToString.put(info.runtime_id(), (String)stringId);
            });
        }

        public String fromIntId(int itemId) {
            return this.runtimeIdToString.get(itemId);
        }

        public Integer fromStringId(String itemId) {
            return this.stringToRuntimeId.get(itemId);
        }

        public Map<String, ItemTypeInfo> getEntries() {
            return this.allEntries;
        }
    }
}

