/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter;

import com.github.blackjack200.ouranos.converter.BlockStateDictionary;
import com.github.blackjack200.ouranos.converter.ChunkRewriteException;
import com.github.blackjack200.ouranos.converter.ItemTranslator;
import com.github.blackjack200.ouranos.converter.ItemTypeDictionary;
import com.github.blackjack200.ouranos.converter.PaletteStorage;
import com.github.blackjack200.ouranos.converter.palette.Palette;
import com.github.blackjack200.ouranos.data.ItemTypeInfo;
import com.github.blackjack200.ouranos.data.bedrock.GlobalItemDataHandlers;
import com.github.blackjack200.ouranos.shaded.lombok.Generated;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v361.Bedrock_v361;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v465.Bedrock_v465;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v475.Bedrock_v475;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v503.Bedrock_v503;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.definitions.BlockDefinition;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.definitions.SimpleItemDefinition;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.CreativeItemData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.descriptor.ComplexAliasDescriptor;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.descriptor.DefaultDescriptor;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.descriptor.DeferredDescriptor;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.descriptor.InvalidDescriptor;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.descriptor.ItemDescriptor;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.descriptor.ItemTagDescriptor;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.descriptor.MolangDescriptor;
import com.github.blackjack200.ouranos.utils.SimpleBlockDefinition;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.ReferenceCountUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NBTOutputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtUtils;

public final class TypeConverter {
    public static int[] translateItemRuntimeId(int input, int output, int runtimeId, int meta) {
        ItemData newItem = TypeConverter.translateItemData(input, output, ItemData.builder().definition(new SimpleItemDefinition("", runtimeId, false)).damage(meta).count(1).build());
        return new int[]{newItem.getDefinition().getRuntimeId(), newItem.getDamage()};
    }

    public static ItemData translateItemData(int input, int output, ItemData itemData) {
        ItemTypeDictionary.InnerEntry itemDict;
        ItemTypeInfo itemTypeInfo;
        ItemData polyfill;
        if (itemData.isNull() || !itemData.isValid()) {
            return itemData;
        }
        if (itemData.getTag() != null && (polyfill = ItemTranslator.recoverPolyfillItem(itemData)) != null) {
            return polyfill;
        }
        ItemDefinition def = itemData.getDefinition();
        ItemData.Builder builder = itemData.toBuilder();
        String translatedId = def.getIdentifier();
        if (translatedId.isEmpty()) {
            translatedId = ItemTypeDictionary.getInstance(input).fromIntId(def.getRuntimeId());
        }
        int translatedMeta = itemData.getDamage();
        Object[] rawData = GlobalItemDataHandlers.getUpgrader().idMetaUpgrader().upgrade(translatedId, translatedMeta);
        translatedId = rawData[0].toString();
        translatedMeta = (Integer)rawData[1];
        rawData = GlobalItemDataHandlers.getItemIdMetaDowngrader(output).downgrade(translatedId, translatedMeta);
        translatedId = rawData[0].toString();
        translatedMeta = (Integer)rawData[1];
        if (itemData.getBlockDefinition() != null) {
            BlockStateDictionary.Dictionary.BlockEntry inputState;
            BlockStateDictionary.Dictionary inputDict = BlockStateDictionary.getInstance(input);
            BlockStateDictionary.Dictionary outputDict = BlockStateDictionary.getInstance(output);
            BlockStateDictionary.Dictionary.BlockEntry outputState = outputDict.lookupStateFromStateHash((inputState = inputDict.lookupStateFromStateHash(inputDict.toLatestStateHash(itemData.getBlockDefinition().getRuntimeId()))).latestStateHash());
            if (outputState != null) {
                builder.blockDefinition(new com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.definitions.SimpleBlockDefinition(outputState.name(), outputDict.toRuntimeId(outputState.latestStateHash()), outputState.rawState()));
            } else {
                builder.blockDefinition(null);
            }
        }
        if ((itemTypeInfo = (ItemTypeInfo)(itemDict = ItemTypeDictionary.getInstance(output)).getEntries().getOrDefault(translatedId, null)) == null) {
            return ItemTranslator.makePolyfillItem(input, output, itemData);
        }
        builder.definition(itemTypeInfo.toDefinition(translatedId)).damage(translatedMeta);
        return builder.build();
    }

    public static int rewriteFullChunk(int input, int output, ByteBuf from, ByteBuf to, int dimension, int sections) throws ChunkRewriteException {
        ArrayList<ByteBuf> subChunks = new ArrayList<ByteBuf>();
        for (int section = 0; section < sections; ++section) {
            ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
            TypeConverter.rewriteSubChunk(input, output, from, buf);
            subChunks.add(buf);
        }
        ArrayList allSubChunks = new ArrayList(subChunks);
        if (subChunks.size() >= 4 && input > Bedrock_v475.CODEC.getProtocolVersion() && output < Bedrock_v475.CODEC.getProtocolVersion()) {
            subChunks.subList(0, 4).clear();
        }
        if (subChunks.size() >= 20 && input > Bedrock_v465.CODEC.getProtocolVersion() && output < Bedrock_v465.CODEC.getProtocolVersion()) {
            subChunks.subList(subChunks.size() - 4, subChunks.size()).clear();
        }
        for (ByteBuf subChunk : subChunks) {
            to.writeBytes(subChunk);
        }
        for (ByteBuf subChunk : allSubChunks) {
            ReferenceCountUtil.release((Object)subChunk);
        }
        if (output < Bedrock_v361.CODEC.getProtocolVersion()) {
            to.writeBytes(new byte[512]);
        }
        ByteBuf biomeBuf = TypeConverter.rewriteBiomePalette(input, output, from, TypeConverter.getDimensionChunkBounds(input, dimension), TypeConverter.getDimensionChunkBounds(output, dimension));
        to.writeBytes(biomeBuf);
        ReferenceCountUtil.release((Object)biomeBuf);
        byte borderBlocks = from.readByte();
        to.writeByte((int)borderBlocks);
        to.writeBytes(from, (int)borderBlocks);
        TypeConverter.rewriteBlockEntities(input, output, from, to);
        return subChunks.size();
    }

    private static ByteBuf rewriteBiomePalette(int input, int output, ByteBuf from, int nInputSection, int nOutputSection) throws ChunkRewriteException {
        int y;
        int biomeId;
        int z;
        int x;
        ByteBuf biomeBuf = ByteBufAllocator.DEFAULT.buffer().touch();
        ArrayList<Palette> palettes = new ArrayList<Palette>();
        if (input >= Bedrock_v475.CODEC.getProtocolVersion()) {
            for (int x2 = nInputSection; x2 > 0; --x2) {
                palettes.add(Palette.readNetwork(from, v -> v));
            }
        } else {
            ByteBuf biomeData = from.readBytes(256);
            Palette palette = new Palette(0);
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    biomeId = biomeData.getByte(z << 4 | x);
                    for (y = 0; y < 16; ++y) {
                        palette.set(x, z, y, biomeId);
                    }
                }
            }
            for (x = nInputSection; x > 0; --x) {
                palettes.add(palette);
            }
        }
        if (output >= Bedrock_v475.CODEC.getProtocolVersion()) {
            if (nInputSection > nOutputSection) {
                palettes = new ArrayList(palettes.subList(0, nOutputSection));
            } else if (nInputSection < nOutputSection) {
                Palette firstPalette = palettes.isEmpty() ? new Palette(0) : (Palette)palettes.get(palettes.size() - 1);
                for (int i = 0; i < nOutputSection - nInputSection; ++i) {
                    palettes.add(firstPalette);
                }
            }
            for (Palette palette : palettes) {
                palette.writeNetwork(biomeBuf, output, v -> v);
            }
        } else {
            Palette palette = (Palette)palettes.get(0);
            byte[] bytes = new byte[256];
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    biomeId = (Integer)palette.get(x, 0, z);
                    for (y = 0; y < 16; ++y) {
                        bytes[z << 4 | x] = (byte)(biomeId & 0xFF);
                    }
                }
            }
            biomeBuf.writeBytes(bytes);
        }
        return biomeBuf;
    }

    public static void rewriteBlockEntities(int input, int output, ByteBuf from, ByteBuf to) {
        try (ByteBufInputStream inp = new ByteBufInputStream(from);
             NBTInputStream reader = NbtUtils.createNetworkReader((InputStream)inp);
             ByteBufOutputStream toStream = new ByteBufOutputStream(to);
             NBTOutputStream rd = NbtUtils.createNetworkWriter((OutputStream)toStream);){
            while (inp.available() > 0) {
                String id;
                NbtMap tag = (NbtMap)reader.readTag();
                if (tag == null || (id = tag.getString("id")).isEmpty()) continue;
                rd.writeTag((Object)TypeConverter.translateBlockEntity(input, output, tag));
            }
        }
    }

    private static NbtMap translateBlockEntity(int input, int output, NbtMap tag) {
        NbtMapBuilder builder = tag.toBuilder();
        String id = tag.getString("id");
        if (id.equals("Sign") && tag.containsKey((Object)"FrontText")) {
            builder.putString("Text", tag.getCompound("FrontText").getString("Text"));
        }
        return builder.build();
    }

    private static int getDimensionChunkBounds(int protocol, int dimension) {
        switch (dimension) {
            case 0: {
                return protocol >= Bedrock_v503.CODEC.getProtocolVersion() ? 24 : 25;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 16;
            }
        }
        return protocol >= Bedrock_v503.CODEC.getProtocolVersion() ? 24 : 25;
    }

    public static void rewriteSubChunk(int input, int output, ByteBuf from, ByteBuf to) throws ChunkRewriteException {
        boolean isNineSubChunkSupported;
        short version = from.readUnsignedByte();
        boolean bl = isNineSubChunkSupported = output >= Bedrock_v465.CODEC.getProtocolVersion();
        if (!isNineSubChunkSupported && version == 9) {
            to.writeByte(8);
        } else {
            to.writeByte((int)version);
        }
        switch (version) {
            case 0: 
            case 4: 
            case 139: {
                to.writeBytes(from, 6144);
                break;
            }
            case 1: {
                PaletteStorage.translatePaletteStorage(input, output, from, to, TypeConverter::translateBlockRuntimeId);
                break;
            }
            case 8: 
            case 9: {
                int storageCount = from.readUnsignedByte();
                to.writeByte(storageCount);
                if (version == 9) {
                    short v = from.readUnsignedByte();
                    if (isNineSubChunkSupported) {
                        to.writeByte((int)v);
                    }
                }
                for (int storage = 0; storage < storageCount; ++storage) {
                    PaletteStorage.translatePaletteStorage(input, output, from, to, TypeConverter::translateBlockRuntimeId);
                }
                break;
            }
            default: {
                throw new ChunkRewriteException("ChunkDataRewrite: Unknown subchunk format " + version);
            }
        }
    }

    public static int translateBlockRuntimeId(int input, int output, int blockRuntimeId) {
        BlockStateDictionary.Dictionary inputDict = BlockStateDictionary.getInstance(input);
        BlockStateDictionary.Dictionary outputDict = BlockStateDictionary.getInstance(output);
        Integer stateHash = inputDict.toLatestStateHash(blockRuntimeId);
        if (stateHash == null) {
            return outputDict.getFallbackRuntimeId();
        }
        Integer translated = outputDict.toRuntimeId(stateHash);
        if (translated == null) {
            return outputDict.getFallbackRuntimeId();
        }
        return translated;
    }

    public static BlockDefinition translateBlockDefinition(int input, int output, BlockDefinition definition) {
        return new SimpleBlockDefinition(TypeConverter.translateBlockRuntimeId(input, output, definition.getRuntimeId()));
    }

    public static ItemDescriptor translateItemDescriptor(int input, int output, ItemDescriptor descriptor) {
        if (descriptor instanceof ComplexAliasDescriptor) {
            ComplexAliasDescriptor d = (ComplexAliasDescriptor)descriptor;
            return d;
        }
        if (descriptor instanceof DefaultDescriptor) {
            DefaultDescriptor d = (DefaultDescriptor)descriptor;
            ItemData itemData = TypeConverter.translateItemData(input, output, ItemData.builder().count(1).damage(d.getAuxValue()).definition(d.getItemId()).build());
            if (itemData == null) {
                return InvalidDescriptor.INSTANCE;
            }
            return new DefaultDescriptor(itemData.getDefinition(), itemData.getDamage());
        }
        if (descriptor instanceof DeferredDescriptor) {
            DeferredDescriptor d = (DeferredDescriptor)descriptor;
            Object[] newData = GlobalItemDataHandlers.getUpgrader().idMetaUpgrader().upgrade(d.getFullName(), d.getAuxValue());
            Object[] downgraded = GlobalItemDataHandlers.getItemIdMetaDowngrader(output).downgrade(newData[0].toString(), (Integer)newData[1]);
            String newStringId = downgraded[0].toString();
            Integer newMeta = (Integer)downgraded[1];
            ItemTypeInfo typ = ItemTypeDictionary.getInstance(output).getEntries().get(newStringId);
            return new DefaultDescriptor(typ.toDefinition(newStringId), newMeta);
        }
        if (descriptor instanceof InvalidDescriptor) {
            InvalidDescriptor d = (InvalidDescriptor)descriptor;
        } else {
            if (descriptor instanceof ItemTagDescriptor) {
                ItemTagDescriptor d = (ItemTagDescriptor)descriptor;
                return d;
            }
            if (descriptor instanceof MolangDescriptor) {
                MolangDescriptor d = (MolangDescriptor)descriptor;
                return d;
            }
        }
        return InvalidDescriptor.INSTANCE;
    }

    public static CreativeItemData translateCreativeItemData(int input, int output, CreativeItemData itemData) {
        ItemData item = TypeConverter.translateItemData(input, output, itemData.getItem());
        return new CreativeItemData(item, itemData.getNetId(), itemData.getGroupId());
    }

    @Generated
    private TypeConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

