/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.data;

import com.github.blackjack200.ouranos.ProtocolInfo;
import com.github.blackjack200.ouranos.shaded.hutool.core.io.FileUtil;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodec;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.function.BiConsumer;

public class AbstractMapping {
    protected static void load(String file, BiConsumer<Integer, InputStream> handler) {
        ProtocolInfo.getPacketCodecs().forEach(codec -> {
            int protocolId = codec.getProtocolVersion();
            String name = AbstractMapping.lookupAvailableFile(file, protocolId);
            try (InputStream rawData = AbstractMapping.open(name);){
                handler.accept(protocolId, rawData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected static InputStream open(String file) {
        return ProtocolInfo.class.getClassLoader().getResourceAsStream(file);
    }

    protected static String lookupAvailableFile(String file, int protocolId) {
        List<BedrockCodec> exists = ProtocolInfo.getPacketCodecs().stream().filter(id -> ProtocolInfo.class.getClassLoader().getResource("vanilla/v" + id.getProtocolVersion() + "/" + file) != null).toList();
        Object name = "vanilla/v" + protocolId + "/" + file;
        if (ProtocolInfo.class.getClassLoader().getResource((String)name) == null) {
            name = file;
        }
        if (ProtocolInfo.class.getClassLoader().getResource((String)name) == null) {
            for (int i = exists.size() - 1; i >= 0; --i) {
                BedrockCodec codecc = exists.get(i);
                name = "vanilla/v" + codecc.getProtocolVersion() + "/" + file;
                if (codecc.getProtocolVersion() <= protocolId) break;
            }
        }
        if (ProtocolInfo.class.getClassLoader().getResource((String)name) == null) {
            name = file;
        }
        return name;
    }

    protected static void loadFile(String file, BiConsumer<Integer, URL> handler) {
        List<BedrockCodec> exists = ProtocolInfo.getPacketCodecs().stream().filter(id -> FileUtil.exist("vanilla/v" + id.getProtocolVersion() + "/" + file)).toList();
        ProtocolInfo.getPacketCodecs().forEach(codec -> {
            int protocolId = codec.getProtocolVersion();
            Object name = "vanilla/v" + protocolId + "/" + file;
            if (!FileUtil.exist((String)name)) {
                name = file;
            }
            if (!FileUtil.exist((String)name)) {
                for (int i = exists.size() - 1; i >= 0; --i) {
                    BedrockCodec codecc = (BedrockCodec)exists.get(i);
                    name = "vanilla/v" + codecc.getProtocolVersion() + "/" + file;
                    if (codecc.getProtocolVersion() <= codec.getProtocolVersion()) break;
                }
            }
            URL url = ProtocolInfo.class.getClassLoader().getResource((String)name);
            handler.accept(protocolId, url);
        });
    }
}

