/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.date;

import com.github.blackjack200.ouranos.shaded.hutool.core.date.Month;
import com.github.blackjack200.ouranos.shaded.hutool.core.date.YearQuarter;
import com.github.blackjack200.ouranos.shaded.hutool.core.lang.Assert;
import java.time.DateTimeException;
import java.time.MonthDay;
import java.time.temporal.ChronoField;

public enum Quarter {
    Q1(1),
    Q2(2),
    Q3(3),
    Q4(4);

    private final int value;
    private final int firstMonth;
    private final int lastMonth;

    private Quarter(int value) {
        this.value = value;
        this.lastMonth = value * 3;
        this.firstMonth = this.lastMonth - 2;
    }

    public int getValue() {
        return this.value;
    }

    public static Quarter of(int intValue) {
        switch (intValue) {
            case 1: {
                return Q1;
            }
            case 2: {
                return Q2;
            }
            case 3: {
                return Q3;
            }
            case 4: {
                return Q4;
            }
        }
        return null;
    }

    public static Quarter fromMonth(int monthValue) {
        ChronoField.MONTH_OF_YEAR.checkValidValue(monthValue);
        return Quarter.of(Quarter.computeQuarterValueInternal(monthValue));
    }

    public static Quarter fromMonth(Month month) {
        Assert.notNull(month);
        int monthValue = month.getValue();
        return Quarter.of(Quarter.computeQuarterValueInternal(monthValue));
    }

    public final YearQuarter atYear(int year) {
        return YearQuarter.of(year, this);
    }

    public Quarter plus(int quarters) {
        int amount = quarters % 4 + 4;
        return Quarter.values()[(this.ordinal() + amount) % 4];
    }

    public Month firstMonth() {
        return Month.of(this.firstMonthValue() - 1);
    }

    public int firstMonthValue() {
        return this.firstMonth;
    }

    public Month lastMonth() {
        return Month.of(this.lastMonthValue() - 1);
    }

    public int lastMonthValue() {
        return this.lastMonth;
    }

    public MonthDay firstMonthDay() {
        return MonthDay.of(this.firstMonthValue(), 1);
    }

    public MonthDay lastMonthDay() {
        Month month = this.lastMonth();
        return MonthDay.of(month.toJdkMonth(), month.getLastDay(false));
    }

    public static int checkValidIntValue(int value) {
        Assert.isTrue(value >= 1 && value <= 4, () -> new DateTimeException("Invalid value for Quarter: " + value));
        return value;
    }

    private static int computeQuarterValueInternal(int monthValue) {
        return (monthValue - 1) / 3 + 1;
    }
}

