/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.lang.func;

import com.github.blackjack200.ouranos.shaded.hutool.core.bean.BeanUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.lang.func.Func0;
import com.github.blackjack200.ouranos.shaded.hutool.core.lang.func.Func1;
import com.github.blackjack200.ouranos.shaded.hutool.core.map.WeakConcurrentMap;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.ClassUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.ReflectUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;

public class LambdaUtil {
    private static final WeakConcurrentMap<String, SerializedLambda> cache = new WeakConcurrentMap();

    public static <R> Class<R> getRealClass(Func0<?> func) {
        SerializedLambda lambda = LambdaUtil.resolve(func);
        LambdaUtil.checkLambdaTypeCanGetClass(lambda.getImplMethodKind());
        return ClassUtil.loadClass(lambda.getImplClass());
    }

    public static <T> SerializedLambda resolve(Func1<T, ?> func) {
        return LambdaUtil._resolve(func);
    }

    public static <R> SerializedLambda resolve(Func0<R> func) {
        return LambdaUtil._resolve(func);
    }

    public static <P> String getMethodName(Func1<P, ?> func) {
        return LambdaUtil.resolve(func).getImplMethodName();
    }

    public static <R> String getMethodName(Func0<R> func) {
        return LambdaUtil.resolve(func).getImplMethodName();
    }

    public static <P, R> Class<P> getRealClass(Func1<P, R> func) {
        SerializedLambda lambda = LambdaUtil.resolve(func);
        LambdaUtil.checkLambdaTypeCanGetClass(lambda.getImplMethodKind());
        String instantiatedMethodType = lambda.getInstantiatedMethodType();
        return ClassUtil.loadClass(StrUtil.sub(instantiatedMethodType, 2, StrUtil.indexOf(instantiatedMethodType, ';')));
    }

    public static <T> String getFieldName(Func1<T, ?> func) throws IllegalArgumentException {
        return BeanUtil.getFieldName(LambdaUtil.getMethodName(func));
    }

    public static <T> String getFieldName(Func0<T> func) throws IllegalArgumentException {
        return BeanUtil.getFieldName(LambdaUtil.getMethodName(func));
    }

    private static void checkLambdaTypeCanGetClass(int implMethodKind) {
        if (implMethodKind != 5 && implMethodKind != 6) {
            throw new IllegalArgumentException("\u8be5lambda\u4e0d\u662f\u5408\u9002\u7684\u65b9\u6cd5\u5f15\u7528");
        }
    }

    private static SerializedLambda _resolve(Serializable func) {
        return cache.computeIfAbsent(func.getClass().getName(), key -> (SerializedLambda)ReflectUtil.invoke((Object)func, "writeReplace", new Object[0]));
    }
}

