/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v776.serializer;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v407.serializer.CreativeContentSerializer_v407;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.CreativeItemCategory;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.CreativeItemData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.CreativeItemGroup;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.CreativeContentPacket;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;

public class CreativeContentSerializer_v776
extends CreativeContentSerializer_v407 {
    public static final CreativeContentSerializer_v776 INSTANCE = new CreativeContentSerializer_v776();
    protected static final CreativeItemCategory[] CATEGORIES = CreativeItemCategory.values();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, CreativeContentPacket packet) {
        helper.writeArray(buffer, packet.getGroups(), this::writeCreativeGroup);
        helper.writeArray(buffer, packet.getContents(), this::writeCreativeItem);
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, CreativeContentPacket packet) {
        helper.readArray(buffer, packet.getGroups(), this::readCreativeGroup);
        helper.readArray(buffer, packet.getContents(), this::readCreativeItem);
    }

    protected CreativeItemGroup readCreativeGroup(ByteBuf buffer, BedrockCodecHelper helper) {
        CreativeItemCategory category = CATEGORIES[buffer.readIntLE()];
        String name = helper.readString(buffer);
        ItemData icon = helper.readItemInstance(buffer);
        return new CreativeItemGroup(category, name, icon);
    }

    protected void writeCreativeGroup(ByteBuf buffer, BedrockCodecHelper helper, CreativeItemGroup item) {
        buffer.writeIntLE(item.getCategory().ordinal());
        helper.writeString(buffer, item.getName());
        helper.writeItemInstance(buffer, item.getIcon());
    }

    @Override
    protected CreativeItemData readCreativeItem(ByteBuf buffer, BedrockCodecHelper helper) {
        int netId = VarInts.readUnsignedInt(buffer);
        ItemData item = helper.readItemInstance(buffer);
        int groupId = VarInts.readUnsignedInt(buffer);
        return new CreativeItemData(item, netId, groupId);
    }

    @Override
    protected void writeCreativeItem(ByteBuf buffer, BedrockCodecHelper helper, CreativeItemData item) {
        VarInts.writeUnsignedInt(buffer, item.getNetId());
        helper.writeItemInstance(buffer, item.getItem());
        VarInts.writeUnsignedInt(buffer, item.getGroupId());
    }

    protected CreativeContentSerializer_v776() {
    }
}

