/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet;

import com.github.blackjack200.ouranos.shaded.fastutil.objects.ObjectArrayList;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacketHandler;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacketType;
import com.github.blackjack200.ouranos.shaded.protocol.common.PacketSignal;
import java.util.List;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;

public class ExplodePacket
implements BedrockPacket {
    private final List<Vector3i> records = new ObjectArrayList<Vector3i>();
    private Vector3f position;
    private float radius;

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.EXPLODE;
    }

    @Override
    public ExplodePacket clone() {
        try {
            return (ExplodePacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public List<Vector3i> getRecords() {
        return this.records;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExplodePacket)) {
            return false;
        }
        ExplodePacket other = (ExplodePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.radius, other.radius) != 0) {
            return false;
        }
        List<Vector3i> this$records = this.records;
        List<Vector3i> other$records = other.records;
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        Vector3f this$position = this.position;
        Vector3f other$position = other.position;
        return !(this$position == null ? other$position != null : !this$position.equals(other$position));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExplodePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.radius);
        List<Vector3i> $records = this.records;
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        Vector3f $position = this.position;
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        return result;
    }

    public String toString() {
        return "ExplodePacket(records=" + this.records + ", position=" + this.position + ", radius=" + this.radius + ")";
    }
}

