/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.transformer;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.tree.AnnotationNode;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.FieldNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.classtransform.TransformerManager;
import oxy.geyser.reversion.shaded.classtransform.annotations.InjectionInfo;
import oxy.geyser.reversion.shaded.classtransform.utils.Types;
import oxy.geyser.reversion.shaded.classtransform.utils.annotations.AnnotationParser;
import oxy.geyser.reversion.shaded.classtransform.utils.annotations.AnnotationUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.mappings.Remapper;

@ParametersAreNonnullByDefault
public abstract class AnnotationHandler {
    public abstract void transform(TransformerManager var1, ClassNode var2, ClassNode var3);

    @Nullable
    protected <T extends Annotation> T getAnnotation(Class<T> annotationClass, ClassNode classNode, TransformerManager transformerManager) {
        T annotation = this.getAnnotation(annotationClass, classNode.visibleAnnotations, transformerManager);
        if (annotation == null) {
            annotation = this.getAnnotation(annotationClass, classNode.invisibleAnnotations, transformerManager);
        }
        return annotation;
    }

    @Nullable
    protected <T extends Annotation> T getAnnotation(Class<T> annotationClass, FieldNode field, TransformerManager transformerManager) {
        T annotation = this.getAnnotation(annotationClass, field.visibleAnnotations, transformerManager);
        if (annotation == null) {
            annotation = this.getAnnotation(annotationClass, field.invisibleAnnotations, transformerManager);
        }
        return annotation;
    }

    @Nullable
    protected <T extends Annotation> T getAnnotation(Class<T> annotationClass, MethodNode method, TransformerManager transformerManager) {
        T annotation = this.getAnnotation(annotationClass, method.visibleAnnotations, transformerManager);
        if (annotation == null) {
            annotation = this.getAnnotation(annotationClass, method.invisibleAnnotations, transformerManager);
        }
        return annotation;
    }

    @Nullable
    protected <T extends Annotation> T getAnnotation(Class<T> annotationClass, @Nullable List<AnnotationNode> annotations, TransformerManager transformerManager) {
        if (annotations != null) {
            for (AnnotationNode annotation : annotations) {
                if (!annotation.desc.equals(Types.typeDescriptor(annotationClass))) continue;
                return AnnotationParser.parse(annotationClass, transformerManager, AnnotationUtils.listToMap(annotation.values));
            }
        }
        return null;
    }

    protected void prepareForCopy(ClassNode transformer, FieldNode field) {
        AnnotationNode injectionInfo = new AnnotationNode(Types.typeDescriptor(InjectionInfo.class));
        injectionInfo.values = Arrays.asList("transformer", transformer.name, "originalName", field.name + ":" + field.desc);
        if (field.invisibleAnnotations == null) {
            field.invisibleAnnotations = new ArrayList<AnnotationNode>();
        }
        field.invisibleAnnotations.add(injectionInfo);
    }

    protected void prepareForCopy(ClassNode transformer, MethodNode method) {
        AnnotationNode injectionInfo = new AnnotationNode(Types.typeDescriptor(InjectionInfo.class));
        injectionInfo.values = Arrays.asList("transformer", transformer.name, "originalName", method.name + method.desc);
        if (method.invisibleAnnotations == null) {
            method.invisibleAnnotations = new ArrayList<AnnotationNode>();
        }
        method.invisibleAnnotations.add(injectionInfo);
    }

    protected MethodNode renameAndCopy(MethodNode injectionMethod, MethodNode targetMethod, ClassNode transformer, ClassNode transformedClass, String extra) {
        this.prepareForCopy(transformer, injectionMethod);
        int i = 0;
        String baseName = injectionMethod.name + "$" + targetMethod.name.replaceAll("[<>]", "") + "$" + extra;
        do {
            injectionMethod.name = baseName + i++;
        } while (this.hasMethod(transformedClass, injectionMethod.name));
        return Remapper.remapAndAdd(transformer, transformedClass, injectionMethod);
    }

    private boolean hasMethod(ClassNode node, String name) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals(name)) continue;
            return true;
        }
        return false;
    }
}

