/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.utils.log.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.classtransform.utils.log.ILogger;
import oxy.geyser.reversion.shaded.classtransform.utils.log.Logger;

@ParametersAreNonnullByDefault
public class SysoutLogger
implements ILogger {
    private static final Pattern ARG_PATTERN = Pattern.compile("\\{}");

    @Override
    public void info(String message, Object ... args) {
        Logger.MessageArgs messageArgs = Logger.resolve(args);
        System.out.println(this.format("INFO ", message, messageArgs.getArgs()));
        if (messageArgs.hasException()) {
            messageArgs.getException().printStackTrace(System.out);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        Logger.MessageArgs messageArgs = Logger.resolve(args);
        System.err.println(this.format("WARN ", message, messageArgs.getArgs()));
        if (messageArgs.hasException()) {
            messageArgs.getException().printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        Logger.MessageArgs messageArgs = Logger.resolve(args);
        System.err.println(this.format("ERROR", message, messageArgs.getArgs()));
        if (messageArgs.hasException()) {
            messageArgs.getException().printStackTrace(System.err);
        }
    }

    protected String format(String level, String message, Object[] args) {
        StringBuffer builder = new StringBuffer();
        builder.append("[").append(level).append("] ");
        Matcher matcher = ARG_PATTERN.matcher(message);
        for (int i = 0; matcher.find() && i < args.length; ++i) {
            matcher.appendReplacement(builder, args[i].toString().replace("$", "\\$"));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }
}

