/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter;

import com.github.blackjack200.ouranos.shaded.gson.JsonObject;
import com.github.blackjack200.ouranos.shaded.gson.JsonParser;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v748.Bedrock_v748;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v766.Bedrock_v766;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v776.Bedrock_v776;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v800.Bedrock_v800;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v827.Bedrock_v827;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v844.Bedrock_v844;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class ItemIdentifierConverter {
    private static TreeMap<Integer, Map<String, String>> ID_TO_ITEMS = new TreeMap();

    public static String translate(String identifier, int target, int client) {
        Map.Entry mapper;
        int protocolVersion;
        if (target <= client) {
            return identifier;
        }
        Iterator iterator = ID_TO_ITEMS.descendingMap().entrySet().iterator();
        while (iterator.hasNext() && (protocolVersion = ((Integer)(mapper = iterator.next()).getKey()).intValue()) >= client) {
            if (protocolVersion > target) continue;
            identifier = ((Map)mapper.getValue()).getOrDefault(identifier, identifier);
        }
        return identifier;
    }

    private static Map<String, String> loadItemMappingsFromFile(String name) {
        HashMap<String, String> identifierToIdentifier = new HashMap<String, String>();
        try {
            String jsonString = new String(Objects.requireNonNull(ItemIdentifierConverter.class.getResourceAsStream("/itemIdentifiers/" + name)).readAllBytes());
            JsonObject object = JsonParser.parseString(jsonString).getAsJsonObject();
            for (String key : object.keySet()) {
                identifierToIdentifier.put(key, object.get(key).getAsString());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return Collections.unmodifiableMap(identifierToIdentifier);
    }

    static {
        ID_TO_ITEMS.put(Bedrock_v844.CODEC.getProtocolVersion(), ItemIdentifierConverter.loadItemMappingsFromFile("itemIdentifiers_v844to827.json"));
        ID_TO_ITEMS.put(Bedrock_v827.CODEC.getProtocolVersion(), ItemIdentifierConverter.loadItemMappingsFromFile("itemIdentifiers_v827to819.json"));
        ID_TO_ITEMS.put(Bedrock_v800.CODEC.getProtocolVersion(), ItemIdentifierConverter.loadItemMappingsFromFile("itemIdentifiers_v800to786.json"));
        ID_TO_ITEMS.put(Bedrock_v776.CODEC.getProtocolVersion(), ItemIdentifierConverter.loadItemMappingsFromFile("itemIdentifiers_v776to766.json"));
        ID_TO_ITEMS.put(Bedrock_v766.CODEC.getProtocolVersion(), ItemIdentifierConverter.loadItemMappingsFromFile("itemIdentifiers_v766to748.json"));
        ID_TO_ITEMS.put(Bedrock_v748.CODEC.getProtocolVersion(), ItemIdentifierConverter.loadItemMappingsFromFile("itemIdentifiers_v748to729.json"));
    }
}

