/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter.bitarray;

import com.github.blackjack200.ouranos.converter.bitarray.BitArray;
import com.github.blackjack200.ouranos.converter.bitarray.BitArrayVersion;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.Preconditions;
import java.util.Arrays;
import org.cloudburstmc.math.GenericMath;

public record Pow2BitArray(BitArrayVersion version, int size, int[] words) implements BitArray
{
    public Pow2BitArray(BitArrayVersion version, int size, int[] words) {
        this.size = size;
        this.version = version;
        this.words = words;
        int expectedWordsLength = GenericMath.ceil((float)((float)size / (float)version.entriesPerWord));
        if (words.length != expectedWordsLength) {
            throw new IllegalArgumentException("Invalid length given for storage, got: " + words.length + " but expected: " + expectedWordsLength);
        }
    }

    @Override
    public void set(int index, int value) {
        Preconditions.checkElementIndex(index, this.size);
        if (value < 0 || value > this.version.maxEntryIndex) {
            throw new IllegalArgumentException(String.format("Max value: %s. Received value %s", this.version.maxEntryIndex, value));
        }
        int bitIndex = index * this.version.bits;
        int arrayIndex = bitIndex >> 5;
        int offset = bitIndex & 0x1F;
        this.words[arrayIndex] = this.words[arrayIndex] & ~(this.version.maxEntryIndex << offset) | (value & this.version.maxEntryIndex) << offset;
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex(index, this.size);
        int bitIndex = index * this.version.bits;
        int arrayIndex = bitIndex >> 5;
        int wordOffset = bitIndex & 0x1F;
        return this.words[arrayIndex] >>> wordOffset & this.version.maxEntryIndex;
    }

    @Override
    public BitArray copy() {
        return new Pow2BitArray(this.version, this.size, Arrays.copyOf(this.words, this.words.length));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pow2BitArray)) {
            return false;
        }
        Pow2BitArray that = (Pow2BitArray)o;
        return this.size == that.size && this.version == that.version && Arrays.equals(this.words, that.words);
    }
}

