/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter.block;

import com.github.blackjack200.ouranos.converter.BlockStateDictionary;
import com.github.blackjack200.ouranos.converter.block.impl.BlockHashDowngrader786to776;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v786.Bedrock_v786;
import com.github.blackjack200.ouranos.utils.HashUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class BlockHashDowngrader {
    private static final TreeMap<Integer, Processor> CONVERTERS = new TreeMap();

    public static Integer downgradeHash(BlockStateDictionary.Dictionary.BlockEntry entry, int input, int output) {
        Map.Entry mapper;
        int protocolVersion;
        if (input <= output) {
            return entry.latestStateHash();
        }
        Iterator iterator = CONVERTERS.descendingMap().entrySet().iterator();
        while (iterator.hasNext() && (protocolVersion = ((Integer)(mapper = iterator.next()).getKey()).intValue()) >= output) {
            if (protocolVersion > input) continue;
            entry = ((Processor)mapper.getValue()).process(entry);
        }
        return HashUtils.computeBlockStateHash(entry.name(), entry.rawState());
    }

    static {
        CONVERTERS.put(Bedrock_v786.CODEC.getProtocolVersion(), BlockHashDowngrader786to776::downgradeState);
    }

    private static interface Processor {
        public BlockStateDictionary.Dictionary.BlockEntry process(BlockStateDictionary.Dictionary.BlockEntry var1);
    }
}

