/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.data.bedrock.block;

import com.github.blackjack200.ouranos.converter.BlockStateDictionary;
import com.github.blackjack200.ouranos.shaded.allymc.updater.block.BlockStateUpdaters;
import com.github.blackjack200.ouranos.utils.HashUtils;
import com.github.blackjack200.ouranos.utils.VarInt;
import com.github.blackjack200.ouranos.utils.binary.BinaryStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;

public class BlockIdMetaUpgrader {
    private Map<Integer, Block> mappingTable;

    public BlockIdMetaUpgrader(Map<Integer, Block> mappingTable) {
        this.mappingTable = mappingTable;
    }

    public Block fromLatestStateHash(int hash) {
        return this.mappingTable.get(hash);
    }

    public static BlockIdMetaUpgrader loadFromString(BinaryStream data) {
        HashMap<Integer, Block> mappingTable = new HashMap<Integer, Block>();
        long len = VarInt.readUnsignedVarInt(data);
        int i = 0;
        while ((long)i < len) {
            String legacyStringId = data.getString();
            long pairs = VarInt.readUnsignedVarInt(data);
            int j = 0;
            while ((long)j < pairs) {
                long meta = VarInt.readUnsignedVarInt(data);
                try (NBTInputStream reader = NbtUtils.createReaderLE((InputStream)data);){
                    NbtMap rawState = (NbtMap)reader.readTag();
                    int state = HashUtils.computeBlockStateHash(BlockStateDictionary.hackedUpgradeBlockState(rawState, BlockStateUpdaters.LATEST_VERSION));
                    mappingTable.put(state, new Block(legacyStringId, meta));
                }
                ++j;
            }
            ++i;
        }
        return new BlockIdMetaUpgrader(mappingTable);
    }

    public record Block(String id, long meta) {
    }
}

