/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.allymc.updater.block.context;

import com.github.blackjack200.ouranos.shaded.allymc.updater.common.CompoundTagEditHelper;
import com.github.blackjack200.ouranos.shaded.allymc.updater.common.context.BaseUpdater;
import com.github.blackjack200.ouranos.shaded.allymc.updater.common.context.filter.HasKeyFilter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class BlockUpdater
extends BaseUpdater<BlockUpdater, Builder> {
    private static final Predicate<CompoundTagEditHelper> COMPOUND_FILTER = helper -> helper.getCompoundTag() != null;

    public BlockUpdater(int version) {
        super(version);
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public class Builder
    extends BaseUpdater.Builder {
        public Builder() {
            super(BlockUpdater.this);
        }

        public Builder addProperty(String key, Object value) {
            BlockUpdater.this.filters.add(COMPOUND_FILTER);
            BlockUpdater.this.filters.add(new HasKeyFilter(key, true));
            BlockUpdater.this.updaters.add(helper -> helper.getCompoundTag().put(key, value));
            return this.self();
        }

        public Builder removeProperty(String key) {
            BlockUpdater.this.filters.add(COMPOUND_FILTER);
            BlockUpdater.this.filters.add(new HasKeyFilter(key));
            BlockUpdater.this.updaters.add(helper -> helper.getCompoundTag().remove(key));
            return this.self();
        }

        public Builder renameProperty(String oldKey, String newKey) {
            BlockUpdater.this.filters.add(COMPOUND_FILTER);
            BlockUpdater.this.filters.add(new HasKeyFilter(oldKey));
            BlockUpdater.this.updaters.add(helper -> {
                Map<String, Object> tag = helper.getCompoundTag();
                tag.put(newKey, tag.remove(oldKey));
            });
            return this.self();
        }

        public Builder addCompound(String key) {
            BlockUpdater.this.filters.add(COMPOUND_FILTER);
            BlockUpdater.this.updaters.add(helper -> helper.getCompoundTag().put(key, new LinkedHashMap()));
            return this.self();
        }

        public Builder visit(String key) {
            BlockUpdater.this.filters.add(helper -> {
                Map<String, Object> compoundTag = helper.getCompoundTag();
                if (compoundTag == null || !compoundTag.containsKey(key)) {
                    return false;
                }
                helper.pushChild(key);
                return true;
            });
            BlockUpdater.this.updaters.add(helper -> helper.pushChild(key));
            return this.self();
        }

        public Builder popVisit() {
            BlockUpdater.this.filters.add(helper -> {
                if (helper.canPopChild()) {
                    helper.popChild();
                    return true;
                }
                return false;
            });
            BlockUpdater.this.updaters.add(CompoundTagEditHelper::popChild);
            return this;
        }

        public Builder tryEdit(String name, Consumer<CompoundTagEditHelper> function) {
            BlockUpdater.this.updaters.add(helper -> {
                Map<String, Object> compoundTag = helper.getCompoundTag();
                if (compoundTag == null || !compoundTag.containsKey(name)) {
                    return;
                }
                helper.pushChild(name);
                function.accept((CompoundTagEditHelper)helper);
                helper.popChild();
            });
            return this.self();
        }

        public Builder replaceValue(String property, Object newValue) {
            BlockUpdater.this.filters.add(COMPOUND_FILTER);
            BlockUpdater.this.filters.add(new HasKeyFilter(property));
            BlockUpdater.this.updaters.add(helper -> {
                Map<String, Object> tag = helper.getCompoundTag();
                tag.put(property, newValue);
            });
            return this.self();
        }

        protected Builder self() {
            return this;
        }
    }
}

