/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.allymc.updater.block.context;

import com.github.blackjack200.ouranos.shaded.allymc.updater.block.context.BlockUpdater;
import com.github.blackjack200.ouranos.shaded.allymc.updater.block.context.CopyStates;
import com.github.blackjack200.ouranos.shaded.allymc.updater.block.context.NewState;
import com.github.blackjack200.ouranos.shaded.allymc.updater.block.context.RemapValue;
import com.github.blackjack200.ouranos.shaded.allymc.updater.block.context.StateEditor;
import com.github.blackjack200.ouranos.shaded.allymc.updater.common.context.UpdaterContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class BlockUpdaterContext
extends UpdaterContext<BlockUpdater, BlockUpdater.Builder> {
    public BlockUpdaterContext() {
        super(BlockUpdater::new);
    }

    public void addProperty(String name, String key, Object value) {
        this.addProperty(name, key, value, false);
    }

    public void addProperty(String name, String key, Object value, boolean regex) {
        ((BlockUpdater.Builder)((BlockUpdater.Builder)this.addUpdater()).match("name", name, regex)).visit("states").addProperty(key, value);
    }

    public void removeProperty(String name, String key) {
        this.removeProperty(name, key, false);
    }

    public void removeProperty(String name, String key, boolean regex) {
        ((BlockUpdater.Builder)((BlockUpdater.Builder)this.addUpdater()).match("name", name, regex)).visit("states").removeProperty(key);
    }

    public void renameProperty(String name, String oldKey, String newKey) {
        this.renameProperty(name, oldKey, newKey, false);
    }

    public void renameProperty(String name, String oldKey, String newKey, boolean regex) {
        ((BlockUpdater.Builder)((BlockUpdater.Builder)this.addUpdater()).match("name", name, regex)).visit("states").renameProperty(oldKey, newKey);
    }

    public void renameId(String oldId, String newId) {
        ((BlockUpdater.Builder)this.addUpdater()).renameId("name", oldId, newId);
    }

    public void remapValues(String name, String property, RemapValue ... remaps) {
        ((BlockUpdater.Builder)((BlockUpdater.Builder)this.addUpdater()).match("name", name)).visit("states").tryEdit(property, helper -> {
            Object oldValue = helper.getTag();
            Optional<RemapValue> remapValue = Arrays.stream(remaps).filter(entry -> entry.oldValue().equals(oldValue)).findFirst();
            remapValue.ifPresent(value -> helper.replaceWith(property, value.newValue()));
        });
    }

    public void remapState(String name, String newName, StateEditor ... editors) {
        this.remapState(name, (BlockUpdater.Builder $) -> {}, newName, editors);
    }

    public void remapState(String name, Consumer<BlockUpdater.Builder> filter, String newName, StateEditor ... editors) {
        this.remapState(name, filter, newName, "", "", editors);
    }

    public void remapState(String name, String prefix, String property, String suffix) {
        this.remapState(name, prefix, property, suffix, (StateEditor[])new RemapValue[0]);
    }

    public void remapState(String name, String prefix, String property, String suffix, StateEditor ... editors) {
        this.remapState(name, (BlockUpdater.Builder $) -> {}, prefix, property, suffix, editors);
    }

    public void remapState(String name, Consumer<BlockUpdater.Builder> filter, String prefix, String property, String suffix, StateEditor ... editors) {
        BlockUpdater.Builder updater = ((BlockUpdater.Builder)((BlockUpdater.Builder)this.addUpdater()).match("name", name)).visit("states");
        filter.accept(updater);
        ((BlockUpdater.Builder)updater.edit(property, helper -> {
            String oldValue = String.valueOf(helper.getTag());
            Object remapValue = Arrays.stream(editors).filter(RemapValue.class::isInstance).map(RemapValue.class::cast).filter(entry -> entry.oldValue().equals(oldValue)).findFirst().map(RemapValue::newValue).orElse(oldValue);
            helper.getRootTag().put("name", prefix + String.valueOf(remapValue) + suffix);
        })).removeProperty(property);
        updater.popVisit().edit("states", helper -> {
            Optional<String[]> copiedStates = Arrays.stream(editors).filter(CopyStates.class::isInstance).map(CopyStates.class::cast).map(CopyStates::states).findFirst();
            copiedStates.ifPresent(states -> {
                Set<String> preservedStates = Set.of(states);
                Map<String, Object> nbt = helper.getCompoundTag();
                nbt.keySet().removeIf(key -> !preservedStates.contains(key));
            });
        });
        List<NewState> newStates = Arrays.stream(editors).filter(NewState.class::isInstance).map(NewState.class::cast).toList();
        if (!newStates.isEmpty()) {
            updater.visit("states");
            newStates.forEach(newState -> updater.addProperty(newState.name(), newState.value()));
        }
    }
}

