/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.bean.copier;

import com.github.blackjack200.ouranos.shaded.hutool.core.bean.BeanUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.bean.PropDesc;
import com.github.blackjack200.ouranos.shaded.hutool.core.bean.copier.AbsCopier;
import com.github.blackjack200.ouranos.shaded.hutool.core.bean.copier.CopyOptions;
import com.github.blackjack200.ouranos.shaded.hutool.core.lang.Assert;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanToMapCopier
extends AbsCopier<Object, Map> {
    private final Type[] targetTypeArguments;

    public BeanToMapCopier(Object source, Map target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetTypeArguments = TypeUtil.getTypeArguments(targetType);
    }

    @Override
    public Map copy() {
        Class<?> actualEditable = this.source.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.source), "Source class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> sourcePropDescMap = BeanUtil.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(this.copyOptions.transientSupport)) {
                return;
            }
            if (null == (sFieldName = this.copyOptions.editFieldName((String)sFieldName))) {
                return;
            }
            if (!this.copyOptions.testKeyFilter(sFieldName)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source);
            if (!this.copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            if (null != this.targetTypeArguments && this.targetTypeArguments.length > 1) {
                sValue = this.copyOptions.convertField(this.targetTypeArguments[1], sValue);
            }
            if (null != (sValue = this.copyOptions.editFieldValue((String)sFieldName, sValue)) || !this.copyOptions.ignoreNullValue) {
                ((Map)this.target).put(sFieldName, sValue);
            }
        });
        return (Map)this.target;
    }
}

