/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.convert.impl;

import com.github.blackjack200.ouranos.shaded.hutool.core.bean.BeanUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.convert.AbstractConverter;
import com.github.blackjack200.ouranos.shaded.hutool.core.convert.ConverterRegistry;
import com.github.blackjack200.ouranos.shaded.hutool.core.map.MapUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.StrUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MapConverter
extends AbstractConverter<Map<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final Type mapType;
    private final Type keyType;
    private final Type valueType;

    public MapConverter(Type mapType) {
        this(mapType, TypeUtil.getTypeArgument(mapType, 0), TypeUtil.getTypeArgument(mapType, 1));
    }

    public MapConverter(Type mapType, Type keyType, Type valueType) {
        this.mapType = mapType;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    protected Map<?, ?> convertInternal(Object value) {
        Map<Object, Object> map;
        if (value instanceof Map) {
            Type[] typeArguments;
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(this.mapType) && null != (typeArguments = TypeUtil.getTypeArguments(valueClass)) && 2 == typeArguments.length && Objects.equals(this.keyType, typeArguments[0]) && Objects.equals(this.valueType, typeArguments[1])) {
                return (Map)value;
            }
            Class<AbstractMap> mapClass = TypeUtil.getClass(this.mapType);
            map = null == mapClass || mapClass.isAssignableFrom(AbstractMap.class) ? new LinkedHashMap<String, Object>() : MapUtil.createMap(mapClass);
            this.convertMapToMap((Map)value, map);
        } else if (BeanUtil.isBean(value.getClass())) {
            if (value.getClass().getName().equals("com.github.blackjack200.ouranos.shaded.hutool.json.JSONArray")) {
                throw new UnsupportedOperationException(StrUtil.format("Unsupported {} to Map.", value.getClass().getName()));
            }
            map = BeanUtil.beanToMap(value, new String[0]);
            map = this.convertInternal(map);
        } else {
            throw new UnsupportedOperationException(StrUtil.format("Unsupported toMap value type: {}", value.getClass().getName()));
        }
        return map;
    }

    private void convertMapToMap(Map<?, ?> srcMap, Map<Object, Object> targetMap) {
        ConverterRegistry convert = ConverterRegistry.getInstance();
        srcMap.forEach((key, value) -> {
            key = TypeUtil.isUnknown(this.keyType) ? key : convert.convert(this.keyType, key);
            value = TypeUtil.isUnknown(this.valueType) ? value : convert.convert(this.valueType, value);
            targetMap.put(key, value);
        });
    }

    @Override
    public Class<Map<?, ?>> getTargetType() {
        return TypeUtil.getClass(this.mapType);
    }
}

