/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.io.resource;

import com.github.blackjack200.ouranos.shaded.hutool.core.io.FileUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.io.resource.NoResourceException;
import com.github.blackjack200.ouranos.shaded.hutool.core.io.resource.Resource;
import com.github.blackjack200.ouranos.shaded.hutool.core.lang.Assert;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.ObjectUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.URLUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;

public class FileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final long lastModified;
    private final String name;

    public FileResource(String path) {
        this(FileUtil.file(path));
    }

    public FileResource(Path path) {
        this(path.toFile());
    }

    public FileResource(File file) {
        this(file, null);
    }

    public FileResource(File file, String fileName) {
        Assert.notNull(file, "File must be not null !", new Object[0]);
        this.file = file;
        this.lastModified = file.lastModified();
        this.name = ObjectUtil.defaultIfNull(fileName, file::getName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return URLUtil.getURL(this.file);
    }

    @Override
    public InputStream getStream() throws NoResourceException {
        if (!this.file.exists()) {
            throw new NoResourceException("File [{}] not exist!", this.file.getAbsolutePath());
        }
        return FileUtil.getInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isModified() {
        return this.lastModified != this.file.lastModified();
    }

    public String toString() {
        return this.file.toString();
    }
}

