/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.io.unit;

import com.github.blackjack200.ouranos.shaded.hutool.core.io.unit.DataSize;
import com.github.blackjack200.ouranos.shaded.hutool.core.io.unit.DataUnit;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.ArrayUtil;
import java.text.DecimalFormat;

public class DataSizeUtil {
    public static long parse(String text) {
        return DataSize.parse(text).toBytes();
    }

    public static String format(long size) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = Math.min(DataUnit.UNIT_NAMES.length - 1, (int)(Math.log10(size) / Math.log10(1024.0)));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + DataUnit.UNIT_NAMES[digitGroups];
    }

    public static String format(Long size, DataUnit fileDataUnit) {
        if (size <= 0L) {
            return "0";
        }
        int digitGroups = ArrayUtil.indexOf(DataUnit.UNIT_NAMES, fileDataUnit.getSuffix());
        return new DecimalFormat("##0.##").format((double)size.longValue() / Math.pow(1024.0, digitGroups)) + " " + DataUnit.UNIT_NAMES[digitGroups];
    }
}

