/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.text.csv;

import com.github.blackjack200.ouranos.shaded.hutool.core.io.IORuntimeException;
import com.github.blackjack200.ouranos.shaded.hutool.core.io.IoUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

public class CsvTokener
implements Closeable {
    private final Reader raw;
    private long index;
    private int prev;
    private boolean usePrev;

    public CsvTokener(Reader reader) {
        this.raw = IoUtil.toBuffered(reader);
    }

    public int next() {
        if (this.usePrev) {
            this.usePrev = false;
        } else {
            try {
                this.prev = this.raw.read();
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        ++this.index;
        return this.prev;
    }

    public void back() throws IllegalStateException {
        if (this.usePrev || this.index <= 0L) {
            throw new IllegalStateException("Stepping back two steps is not supported");
        }
        --this.index;
        this.usePrev = true;
    }

    public long getIndex() {
        return this.index;
    }

    @Override
    public void close() throws IOException {
        IoUtil.close(this.raw);
    }
}

