/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.util;

import com.github.blackjack200.ouranos.shaded.hutool.core.exceptions.UtilException;
import com.github.blackjack200.ouranos.shaded.hutool.core.io.FileUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.io.IoUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.CharsetUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.StrUtil;
import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JAXBUtil {
    public static String beanToXml(Object bean) {
        return JAXBUtil.beanToXml(bean, CharsetUtil.CHARSET_UTF_8, true);
    }

    public static String beanToXml(Object bean, Charset charset, boolean format) {
        StringWriter writer;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{bean.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)format);
            marshaller.setProperty("jaxb.encoding", (Object)charset.name());
            writer = new StringWriter();
            marshaller.marshal(bean, (Writer)writer);
        }
        catch (Exception e) {
            throw new UtilException("convertToXml \u9519\u8bef\uff1a" + e.getMessage(), e);
        }
        return writer.toString();
    }

    public static <T> T xmlToBean(String xml, Class<T> c) {
        return JAXBUtil.xmlToBean(StrUtil.getReader(xml), c);
    }

    public static <T> T xmlToBean(File file, Charset charset, Class<T> c) {
        return JAXBUtil.xmlToBean(FileUtil.getReader(file, charset), c);
    }

    public static <T> T xmlToBean(Reader reader, Class<T> c) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal(reader);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("convertToJava2 \u9519\u8bef\uff1a" + e.getMessage(), e);
        }
        finally {
            IoUtil.close(reader);
        }
    }
}

