/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.BedrockPeer;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.BedrockSession;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.DisconnectPacket;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BedrockServerSession
extends BedrockSession {
    private static final int TIMEOUT_SECONDS = SystemPropertyUtil.getInt((String)"com.github.blackjack200.ouranos.shaded.protocol.bedrock.disconnectTimeout", (int)10);

    public BedrockServerSession(BedrockPeer peer, int subClientId) {
        super(peer, subClientId);
    }

    @Override
    public void disconnect(@Nullable CharSequence reason, boolean hideReason) {
        CharSequence finalReason;
        this.checkForClosed();
        DisconnectPacket packet = new DisconnectPacket();
        if (reason == null || hideReason) {
            packet.setMessageSkipped(true);
            finalReason = "disconnect.disconnected";
        } else {
            finalReason = reason;
        }
        packet.setKickMessage(finalReason);
        this.sendPacketImmediately(packet);
        if (!this.isSubClient()) {
            this.getPeer().blackholeInboundPackets();
        }
        this.getPeer().channel.eventLoop().schedule(() -> {
            if (this.isConnected()) {
                this.close(finalReason);
            }
        }, (long)TIMEOUT_SECONDS, TimeUnit.SECONDS);
    }
}

