/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v332;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.EntityDataTypeMap;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v313.BedrockCodecHelper_v313;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemData;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.TypeMap;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;

public class BedrockCodecHelper_v332
extends BedrockCodecHelper_v313 {
    public BedrockCodecHelper_v332(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes) {
        super(entityData, gameRulesTypes);
    }

    @Override
    public ItemData readItem(ByteBuf buffer) {
        NbtMap compoundTag;
        int count;
        int damage;
        ItemDefinition definition;
        block35: {
            int runtimeId = VarInts.readInt(buffer);
            if (runtimeId == 0) {
                return ItemData.AIR;
            }
            definition = (ItemDefinition)this.itemDefinitions.getDefinition(runtimeId);
            int aux = VarInts.readInt(buffer);
            damage = aux >> 8;
            if (damage == Short.MAX_VALUE) {
                damage = -1;
            }
            count = aux & 0xFF;
            short nbtSize = buffer.readShortLE();
            compoundTag = null;
            if (nbtSize > 0) {
                try (NBTInputStream reader = NbtUtils.createReaderLE((InputStream)new ByteBufInputStream(buffer.readSlice((int)nbtSize)), (long)this.encodingSettings.maxItemNBTSize());){
                    compoundTag = (NbtMap)reader.readTag();
                    break block35;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to load NBT data", e);
                }
            }
            if (nbtSize == -1) {
                short tagCount = buffer.readUnsignedByte();
                if (tagCount != 1) {
                    throw new IllegalArgumentException("Expected 1 tag but got " + tagCount);
                }
                try (NBTInputStream reader = NbtUtils.createNetworkReader((InputStream)new ByteBufInputStream(buffer));){
                    compoundTag = (NbtMap)reader.readTag();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to load NBT data", e);
                }
            }
        }
        String[] canPlace = new String[VarInts.readInt(buffer)];
        for (int i = 0; i < canPlace.length; ++i) {
            canPlace[i] = this.readString(buffer);
        }
        String[] canBreak = new String[VarInts.readInt(buffer)];
        for (int i = 0; i < canBreak.length; ++i) {
            canBreak[i] = this.readString(buffer);
        }
        return ItemData.builder().definition(definition).damage(damage).count(count).tag(compoundTag).canPlace(canPlace).canBreak(canBreak).build();
    }

    @Override
    public void writeItem(ByteBuf buffer, ItemData item) {
        Objects.requireNonNull(item, "item is null!");
        ItemDefinition definition = item.getDefinition();
        if (BedrockCodecHelper_v332.isAir(definition)) {
            buffer.writeByte(0);
            return;
        }
        VarInts.writeInt(buffer, definition.getRuntimeId());
        int damage = item.getDamage();
        if (damage == -1) {
            damage = Short.MAX_VALUE;
        }
        VarInts.writeInt(buffer, damage << 8 | item.getCount() & 0xFF);
        if (item.getTag() != null) {
            buffer.writeShortLE(-1);
            buffer.writeByte(1);
            this.writeTag(buffer, item.getTag());
        } else {
            buffer.writeShortLE(0);
        }
        String[] canPlace = item.getCanPlace();
        VarInts.writeInt(buffer, canPlace.length);
        for (String aCanPlace : canPlace) {
            this.writeString(buffer, aCanPlace);
        }
        String[] canBreak = item.getCanBreak();
        VarInts.writeInt(buffer, canBreak.length);
        for (String aCanBreak : canBreak) {
            this.writeString(buffer, aCanBreak);
        }
    }
}

